/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.service.Device;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.LocalizedString;
import org.ws4d.java.types.ThisDeviceMData;
import org.ws4d.java.types.ThisModelMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.Log;

public abstract class DeviceCommons
implements Device {
    ThisModelMData modelMetadata;
    ThisDeviceMData deviceMetadata;
    boolean secure = false;
    Object certificate;
    Object privateKey;
    private Integer hashCode = null;

    protected DeviceCommons() {
        this(new ThisModelMData(), new ThisDeviceMData());
    }

    protected DeviceCommons(ThisModelMData thisModelMData, ThisDeviceMData thisDeviceMData) {
        this.modelMetadata = thisModelMData;
        this.deviceMetadata = thisDeviceMData;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(" [ remote=").append(this.isRemote());
        stringBuffer.append(", endpointReference=").append(this.getEndpointReference());
        Iterator iterator = this.getPortTypes();
        if (iterator.hasNext()) {
            stringBuffer.append(", types={ ");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next()).append(' ');
            }
            stringBuffer.append('}');
        }
        if ((iterator = this.getScopes()).hasNext()) {
            stringBuffer.append(", scopes={ ");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next()).append(' ');
            }
            stringBuffer.append('}');
        }
        if ((iterator = this.getXAddressInfos()).hasNext()) {
            stringBuffer.append(", xAddresses={ ");
            while (iterator.hasNext()) {
                stringBuffer.append(((XAddressInfo)iterator.next()).getXAddress()).append(' ');
            }
            stringBuffer.append('}');
        }
        stringBuffer.append(", metadataVersion=").append(this.getMetadataVersion());
        stringBuffer.append(", thisModel=").append(this.modelMetadata);
        stringBuffer.append(", thisDevice=").append(this.deviceMetadata);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public String getManufacturer(String string) {
        if (this.modelMetadata == null) {
            return null;
        }
        LocalizedString localizedString = this.modelMetadata.getManufacturerName(string);
        if (localizedString != null) {
            return localizedString.getValue();
        }
        return null;
    }

    public Iterator getManufacturers() {
        if (this.modelMetadata == null) {
            return EmptyStructures.EMPTY_ITERATOR;
        }
        DataStructure dataStructure = this.modelMetadata.getManufacturerNames();
        return dataStructure == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(dataStructure);
    }

    public String getManufacturerUrl() {
        if (this.modelMetadata == null) {
            return null;
        }
        URI uRI = this.modelMetadata.getManufacturerUrl();
        if (uRI != null) {
            return uRI.toString();
        }
        return null;
    }

    public String getModelName(String string) {
        if (this.modelMetadata == null) {
            return null;
        }
        LocalizedString localizedString = this.modelMetadata.getModelName(string);
        if (localizedString != null) {
            return localizedString.getValue();
        }
        return null;
    }

    public Iterator getModelNames() {
        if (this.modelMetadata == null) {
            return EmptyStructures.EMPTY_ITERATOR;
        }
        DataStructure dataStructure = this.modelMetadata.getModelNames();
        return dataStructure == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(dataStructure);
    }

    public String getModelNumber() {
        if (this.modelMetadata == null) {
            return null;
        }
        return this.modelMetadata.getModelNumber();
    }

    public String getModelUrl() {
        if (this.modelMetadata == null) {
            return null;
        }
        URI uRI = this.modelMetadata.getModelUrl();
        if (uRI != null) {
            return uRI.toString();
        }
        return null;
    }

    public String getPresentationUrl() {
        if (this.modelMetadata == null) {
            return null;
        }
        URI uRI = this.modelMetadata.getPresentationUrl();
        if (uRI != null) {
            return uRI.toString();
        }
        return null;
    }

    public String getFriendlyName(String string) {
        if (this.deviceMetadata == null) {
            return null;
        }
        LocalizedString localizedString = this.deviceMetadata.getFriendlyName(string);
        if (localizedString != null) {
            return localizedString.getValue();
        }
        return null;
    }

    public Iterator getFriendlyNames() {
        if (this.deviceMetadata == null) {
            return EmptyStructures.EMPTY_ITERATOR;
        }
        DataStructure dataStructure = this.deviceMetadata.getFriendlyNames();
        return dataStructure == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(dataStructure);
    }

    public String getFirmwareVersion() {
        if (this.deviceMetadata == null) {
            return null;
        }
        return this.deviceMetadata.getFirmwareVersion();
    }

    public String getSerialNumber() {
        if (this.deviceMetadata == null) {
            return null;
        }
        return this.deviceMetadata.getSerialNumber();
    }

    public void setSecureDevice() throws RuntimeException {
        if (!DPWSFramework.hasModule(64)) {
            throw new RuntimeException("You are running the DPWS Framework without the required Security-Module");
        }
        String string = this.getEndpointReference().getAddress().toString();
        if (string == null || string == "") {
            Log.error("Please first set the EPR for this device!");
        }
        this.certificate = DPWSFramework.getSecurityManager().getCertificate(string);
        this.privateKey = DPWSFramework.getSecurityManager().getPrivateKey(string, null);
        this.secure = true;
    }

    public boolean setSecureDevice(String string, String string2, String string3) throws RuntimeException {
        if (!DPWSFramework.hasModule(64)) {
            throw new RuntimeException("You are running the DPWS Framework without the required Security-Module");
        }
        this.certificate = DPWSFramework.getSecurityManager().getCertificate(string);
        this.privateKey = DPWSFramework.getSecurityManager().getPrivateKey(string2, string3);
        if (this.certificate != null && this.privateKey != null) {
            this.secure = true;
            return true;
        }
        return false;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setCertificate(Object object) {
        this.certificate = object;
    }

    public Object getCertificate() {
        return this.certificate;
    }

    public Object getPrivateKey() {
        return this.privateKey;
    }

    void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setPrivateKey(Object object) {
        this.privateKey = object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DeviceCommons)) {
            return false;
        }
        DeviceCommons deviceCommons = (DeviceCommons)object;
        return this.getEndpointReference().equals(deviceCommons.getEndpointReference());
    }

    public int hashCode() {
        int n = 31 + this.getEndpointReference().hashCode();
        if (this.hashCode == null) {
            this.hashCode = new Integer(n);
            return n;
        }
        if (this.hashCode != n) {
            Log.error("DeviceCommons.hashCode(): endpoint reference has been changed " + this.toString());
        }
        return n;
    }
}

