/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.service.parameter;

import java.io.IOException;
import org.ws4d.java.schema.ComplexType;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.NamedObject;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.schema.Type;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.parameter.ParameterAttribute;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.Log;
import org.ws4d.java.wsdl.WSDL;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public abstract class ParameterDefinition
extends ParameterValue {
    public abstract String serialize();

    public abstract void parse(String var1);

    public abstract void parseContent(XmlPullParser var1) throws IOException, XmlPullParserException;

    public abstract void serializeContent(XmlSerializer var1) throws IOException;

    public int getValueType() {
        return -1;
    }

    public static ParameterValue parse(XmlPullParser xmlPullParser, Element element, OperationDescription operationDescription) throws XmlPullParserException, IOException {
        return ParameterDefinition.parse0(xmlPullParser, element, operationDescription);
    }

    private static final ParameterValue[] parse1(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        Object object;
        Object object2;
        int n;
        QName qName = new QName(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser.getPrefix());
        ParameterValue[] parameterValueArray = new ParameterValue[2];
        parameterValueArray[0] = new ParameterValue();
        parameterValueArray[0].setName(qName);
        int n2 = xmlPullParser.getAttributeCount();
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                object2 = new QName(xmlPullParser.getAttributeName(n), xmlPullParser.getAttributeNamespace(n), xmlPullParser.getAttributePrefix(n));
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(((QName)object2).getNamespace()) && "nil".equals(((QName)object2).getLocalPart())) {
                    parameterValueArray[0].setNil(true);
                    continue;
                }
                object = new ParameterAttribute((QName)object2);
                ((ParameterAttribute)object).setValue(xmlPullParser.getAttributeValue(n));
                parameterValueArray[0].add((ParameterAttribute)object);
            }
        }
        n = xmlPullParser.getEventType();
        switch (n) {
            case 0: {
                n = xmlPullParser.nextTag();
                break;
            }
            case 2: {
                if ("http://www.w3.org/2004/08/xop/include".equals(xmlPullParser.getNamespace()) && "Include".equals(xmlPullParser.getName())) {
                    parameterValueArray[1] = ParameterDefinition.load(SchemaUtil.getSchemaType(SchemaUtil.TYPE_BASE64_BINARY));
                    object2 = (ParameterDefinition)parameterValueArray[1];
                    ((ParameterDefinition)object2).parseContent(xmlPullParser);
                    n = xmlPullParser.nextTag();
                    return parameterValueArray;
                }
                n = xmlPullParser.next();
            }
        }
        if (n == 4) {
            parameterValueArray[0] = ParameterDefinition.load(null);
            object2 = (ParameterDefinition)parameterValueArray[0];
            ((ParameterDefinition)object2).parseContent(xmlPullParser);
            n = xmlPullParser.nextTag();
            parameterValueArray[0].setName(qName);
            return parameterValueArray;
        }
        int n3 = xmlPullParser.getDepth();
        while (n != 3 && xmlPullParser.getDepth() >= n3) {
            object = ParameterDefinition.parse1(xmlPullParser);
            if (object[1] != null && object[1].getValueType() == 2) {
                ((ParameterValue)object[1]).setName(qName);
                parameterValueArray[0] = object[1];
                object[1] = null;
            } else {
                parameterValueArray[0].add(object[0]);
            }
            if ((n = xmlPullParser.nextTag()) != 3 || xmlPullParser.getDepth() != n3) continue;
            n = xmlPullParser.nextTag();
        }
        return parameterValueArray;
    }

    private static final ParameterValue parse0(XmlPullParser xmlPullParser, Element element, OperationDescription operationDescription) throws XmlPullParserException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Type type;
        Type type2 = type = element.getType();
        QName qName = new QName(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser.getPrefix());
        if (!qName.equals(element.getName())) {
            throw new IOException("Cannot create parameter. Element mismatch. Should be " + element.getName() + ", but " + qName + " was found.");
        }
        boolean bl = false;
        HashMap hashMap = null;
        int n = xmlPullParser.getAttributeCount();
        if (n > 0) {
            hashMap = new HashMap();
            block0: for (int i = 0; i < n; ++i) {
                object5 = xmlPullParser.getAttributeName(i);
                String string = xmlPullParser.getAttributeNamespace(i);
                object4 = new QName((String)object5, string, xmlPullParser.getAttributePrefix(i));
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(string)) {
                    if ("nil".equals(object5)) {
                        bl = true;
                        continue;
                    }
                    if ("type".equals(object5)) {
                        object3 = xmlPullParser.getAttributeValue(i);
                        if (object3 == null || ((String)object3).trim().length() <= 0) continue;
                        object2 = null;
                        int n2 = ((String)object3).indexOf(":");
                        if (n2 >= 0) {
                            if (n2 > 0) {
                                object2 = ((String)object3).substring(0, n2);
                            }
                            object3 = ((String)object3).substring(n2 + 1);
                        }
                        object = new QName((String)object3, xmlPullParser.getNamespace((String)object2));
                        if (operationDescription == null) continue;
                        Service service = operationDescription.getService();
                        Iterator iterator = service.getDescriptions();
                        while (iterator.hasNext()) {
                            WSDL wSDL = (WSDL)iterator.next();
                            Type type3 = wSDL.getSchemaType((QName)object);
                            if (type3 == null) continue;
                            type2 = type3;
                            continue block0;
                        }
                        continue;
                    }
                    object3 = new ParameterAttribute((QName)object4);
                    ((ParameterAttribute)object3).setValue(xmlPullParser.getAttributeValue(i));
                    hashMap.put(object5, object3);
                    continue;
                }
                object3 = new ParameterAttribute((QName)object4);
                ((ParameterAttribute)object3).setValue(xmlPullParser.getAttributeValue(i));
                hashMap.put(object5, object3);
            }
        }
        ParameterValue parameterValue = null;
        if (!type2.isComplexType()) {
            parameterValue = ParameterDefinition.load(type2);
            object5 = (ParameterDefinition)parameterValue;
            ((ParameterDefinition)object5).parseContent(xmlPullParser);
        } else {
            int n3 = xmlPullParser.nextTag();
            int n4 = xmlPullParser.getDepth();
            parameterValue = new ParameterValue();
            object4 = (ComplexType)type2;
            while (n3 != 3 && xmlPullParser.getDepth() >= n4) {
                object3 = new QName(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser.getPrefix());
                object2 = ParameterDefinition.searchElement((ComplexType)object4, (QName)object3);
                ParameterValue parameterValue2 = null;
                if (object2 == null) {
                    if (((NamedObject)object4).getName() != null && ((NamedObject)object4).getName().equals(new QName(SchemaUtil.TYPE_ANYTYPE, "http://www.w3.org/2001/XMLSchema"))) {
                        object = element.getParentSchema();
                        if (object != null) {
                            object2 = ((Schema)object).getElement((QName)object3);
                            parameterValue2 = ParameterDefinition.parse0(xmlPullParser, (Element)object2, operationDescription);
                            if (object2 == null) {
                                ParameterDefinition.parseAnyChild(xmlPullParser, qName, (QName)object3);
                            }
                        } else {
                            parameterValue2 = ParameterDefinition.parseAnyChild(xmlPullParser, qName, (QName)object3);
                        }
                    } else {
                        parameterValue2 = ParameterDefinition.parseAnyChild(xmlPullParser, qName, (QName)object3);
                    }
                } else {
                    parameterValue2 = ParameterDefinition.parse0(xmlPullParser, (Element)object2, operationDescription);
                }
                parameterValue.add(parameterValue2);
                n3 = xmlPullParser.nextTag();
                if (n3 != 3 || xmlPullParser.getDepth() != n4) continue;
                n3 = xmlPullParser.nextTag();
            }
        }
        if (hashMap != null) {
            parameterValue.attributes = hashMap;
            parameterValue.setNil(bl);
        }
        parameterValue.setMaxOccurs(element.getMaxOccurs());
        parameterValue.setMinOccurs(element.getMinOccurs());
        parameterValue.setName(qName);
        parameterValue.setType(type);
        parameterValue.setInstanceType(type2 == type ? null : type2);
        return parameterValue;
    }

    private static final ParameterValue parseAnyChild(XmlPullParser xmlPullParser, QName qName, QName qName2) throws XmlPullParserException, IOException {
        if (Log.isDebug()) {
            Log.debug("Cannot determinate element with name " + qName2 + ". Assuming ANY type.", 4);
        }
        ParameterValue parameterValue = null;
        ParameterValue[] parameterValueArray = ParameterDefinition.parse1(xmlPullParser);
        if (parameterValueArray[1] != null && parameterValueArray[1].getValueType() == 2) {
            parameterValueArray[1].setName(qName);
            parameterValue = parameterValueArray[1];
            parameterValueArray[1] = null;
        } else {
            parameterValue = parameterValueArray[0];
        }
        parameterValue = parameterValueArray[0];
        return parameterValue;
    }

    protected synchronized void serialize0(XmlSerializer xmlSerializer, HashMap hashMap) throws IOException {
        if (hashMap == null) {
            hashMap = this.namespaceCache = this.collectNamespaces(xmlSerializer);
        }
        this.serializeStartTag(xmlSerializer, hashMap);
        this.serializeAttributes(xmlSerializer);
        if (this.hasChildren()) {
            this.serializeChildren(xmlSerializer, hashMap);
        } else {
            this.serializeContent(xmlSerializer);
        }
        this.serializeEndTag(xmlSerializer);
    }

    public String toString() {
        Object object;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PV [ name=");
        stringBuffer.append(this.name);
        String string = this.serialize();
        if (string != null) {
            stringBuffer.append(", value=");
            stringBuffer.append(string);
        }
        if (this.attributes.size() > 0) {
            stringBuffer.append(", attributes=");
            stringBuffer.append("(");
            iterator = this.attributes();
            while (iterator.hasNext()) {
                object = (ParameterAttribute)iterator.next();
                stringBuffer.append(((ParameterAttribute)object).toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        if (this.children.size() > 0) {
            stringBuffer.append(", children=");
            stringBuffer.append("(");
            iterator = this.children();
            while (iterator.hasNext()) {
                object = (ParameterValue)iterator.next();
                stringBuffer.append(((ParameterValue)object).toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(", min=");
        stringBuffer.append(this.min);
        stringBuffer.append(", max=");
        stringBuffer.append(this.max);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

