/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import org.ws4d.java.types.AppSequence;
import org.ws4d.java.util.Log;

public class AppSequenceTracker {
    protected static int MAX_NUMBER_OF_SEQUENCEIDS = 10;
    private int oldestSequenceIdIndex = 0;
    private long latestInstanceId = -1L;
    private String[] sequenceIds = null;
    private long[] latestMessageNumbers = null;
    private long latestNullMessageNumber = -1L;

    public AppSequenceTracker() {
    }

    public AppSequenceTracker(AppSequence appSequence) {
        if (appSequence != null) {
            this.latestInstanceId = appSequence.getInstanceId();
            if (appSequence.getSequenceId() != null) {
                this.sequenceIds = new String[]{appSequence.getSequenceId()};
                this.latestMessageNumbers = new long[]{appSequence.getMessageNumber()};
            } else {
                this.latestNullMessageNumber = appSequence.getMessageNumber();
            }
        }
    }

    public synchronized boolean checkAndUpdate(AppSequence appSequence) {
        int n;
        if (appSequence == null) {
            if (Log.isInfo()) {
                Log.info("Missing AppSequence for checkAndUpdate.");
            }
            return true;
        }
        long l = appSequence.getInstanceId();
        if (l < this.latestInstanceId) {
            return false;
        }
        String string = appSequence.getSequenceId();
        long l2 = appSequence.getMessageNumber();
        if (l > this.latestInstanceId) {
            this.latestInstanceId = l;
            if (this.sequenceIds != null) {
                this.oldestSequenceIdIndex = 0;
                for (int i = 0; i < this.sequenceIds.length; ++i) {
                    this.sequenceIds[i] = null;
                    this.latestMessageNumbers[i] = -1L;
                }
            }
            if (string != null) {
                if (this.sequenceIds == null) {
                    this.sequenceIds = new String[]{string};
                    this.latestMessageNumbers = new long[]{l2};
                } else {
                    this.sequenceIds[0] = string;
                    this.latestMessageNumbers[0] = l2;
                }
                this.latestNullMessageNumber = -1L;
            } else {
                this.latestNullMessageNumber = l2;
            }
            return true;
        }
        if (string == null) {
            if (l2 <= this.latestNullMessageNumber) {
                return false;
            }
            this.latestNullMessageNumber = l2;
            return true;
        }
        if (this.sequenceIds == null) {
            this.sequenceIds = new String[]{string};
            this.latestMessageNumbers = new long[]{l2};
            return true;
        }
        for (n = 0; n < this.sequenceIds.length && this.sequenceIds[n] != null; ++n) {
            if (!this.sequenceIds[n].equals(string)) continue;
            if (l2 <= this.latestMessageNumbers[n]) {
                return false;
            }
            this.latestMessageNumbers[n] = l2;
            return true;
        }
        if (n >= this.sequenceIds.length) {
            if (n < MAX_NUMBER_OF_SEQUENCEIDS) {
                String[] stringArray = new String[++n];
                long[] lArray = new long[n];
                System.arraycopy(this.sequenceIds, 0, stringArray, 0, this.sequenceIds.length);
                System.arraycopy(this.latestMessageNumbers, 0, lArray, 0, this.latestMessageNumbers.length);
                this.sequenceIds = stringArray;
                this.latestMessageNumbers = lArray;
            } else {
                n = this.oldestSequenceIdIndex++;
                if (this.oldestSequenceIdIndex == this.sequenceIds.length) {
                    this.oldestSequenceIdIndex = 0;
                }
            }
        }
        this.sequenceIds[n] = string;
        this.latestMessageNumbers[n] = l2;
        return true;
    }
}

