/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.List;

public class ArrayList
extends List {
    private static final int CAPACITY_DEFAULT = 10;
    final int capacityIncrement;
    Object[] elements;

    public ArrayList() {
        this(10);
    }

    public ArrayList(DataStructure dataStructure) {
        this(dataStructure.size(), 0);
        this.addAll(dataStructure);
    }

    public ArrayList(int n) {
        this(n, 0);
    }

    public ArrayList(int n, int n2) {
        this.elements = new Object[n];
        this.capacityIncrement = n2;
    }

    public ArrayList(Iterator iterator) {
        this(10, 0);
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        ++this.changes;
        this.checkCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = object;
        ++this.size;
    }

    public boolean add(Object object) {
        ++this.changes;
        this.checkCapacity(this.size + 1);
        this.elements[this.size++] = object;
        return true;
    }

    private void checkBounds(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private void checkCapacity(int n) {
        int n2 = this.elements.length;
        if (n > n2) {
            int n3;
            Object[] objectArray = this.elements;
            int n4 = n3 = this.capacityIncrement <= 0 ? (n2 << 1) + 1 : n2 + this.capacityIncrement;
            if (n3 < n) {
                n3 = n;
            }
            this.elements = new Object[n3];
            System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
        }
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = null;
        }
        this.size = 0;
        ++this.changes;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public Object get(int n) {
        this.checkBounds(n);
        return this.elements[n];
    }

    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!object.equals(this.elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object remove(int n) {
        this.checkBounds(n);
        Object object = this.elements[n];
        this.remove0(n);
        return object;
    }

    public boolean remove(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[i] != null) continue;
                this.remove0(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elements[i])) continue;
                this.remove0(i);
                return true;
            }
        }
        return false;
    }

    private void remove0(int n) {
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elements, n + 1, this.elements, n, n2);
        }
        this.elements[--this.size] = null;
        ++this.changes;
    }

    public boolean removeAll(DataStructure dataStructure) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (!dataStructure.contains(this.elements[n2])) continue;
            ++this.changes;
            n3 = n4;
            n4 = n2;
            while (++n4 < this.size && dataStructure.contains(this.elements[n4])) {
                ++this.changes;
            }
            n = n2 - n3;
            System.arraycopy(this.elements, n3, this.elements, n5, n);
            n2 = n4;
            n5 += n;
        }
        if (n4 > 0) {
            n2 = this.size - n4;
            System.arraycopy(this.elements, n4, this.elements, n5, n2);
            for (int i = n = n5 + n2; i < this.size; ++i) {
                this.elements[i] = null;
            }
            this.size = n;
            return true;
        }
        return false;
    }

    public Object set(int n, Object object) {
        this.checkBounds(n);
        Object object2 = this.elements[n];
        this.elements[n] = object;
        return object2;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.elements, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            return this.toArray();
        }
        System.arraycopy(this.elements, 0, objectArray, 0, this.size);
        if (objectArray.length > this.size) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = null;
            }
        }
        return objectArray;
    }
}

