/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

public class ByteArray {
    private static int DEFAULT_SIZE = 8192;
    private int[] resizefac = new int[]{2, 4, 6, 8, 16, 32, 48, 64, 128, 256, 384, 512};
    private int resize = 0;
    private byte[] buffer = new byte[DEFAULT_SIZE];
    private int pointer = -1;

    public void append(byte by) {
        ++this.pointer;
        if (this.resize > 0) {
            --this.resize;
        }
        if (this.pointer == this.buffer.length) {
            this.resize();
        }
        this.buffer[this.pointer] = by;
    }

    public int size() {
        return this.pointer + 1;
    }

    public byte byteAt(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.pointer) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.pointer);
        }
        return this.buffer[n];
    }

    public void trunc() {
        if (this.pointer < this.buffer.length) {
            byte[] byArray = new byte[this.pointer];
            System.arraycopy(this.buffer, 0, byArray, 0, this.pointer);
            this.buffer = byArray;
        }
    }

    public byte[] getBytes() {
        this.trunc();
        return this.buffer;
    }

    private void resize() {
        byte[] byArray = new byte[this.buffer.length * this.resizefac[this.resize]];
        System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
        this.buffer = byArray;
        if (this.resize < this.resizefac.length) {
            ++this.resize;
        }
    }

    public String toString() {
        return new String(this.buffer);
    }
}

