/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.UnsupportedOperationException;

public abstract class DataStructure {
    private static final String CLASS_SHORT_NAME = "DataStructure";

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(DataStructure dataStructure) {
        boolean bl = false;
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (this.contains(object)) continue;
            this.add(object);
            bl = true;
        }
        return bl;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean contains(Object object) {
        if (object == null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAll(DataStructure dataStructure) {
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public String getClassShortName() {
        return CLASS_SHORT_NAME;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(Object object) {
        if (object == null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                return true;
            }
        } else {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    public Object[] toArray() {
        int n = this.size();
        if (n == 0) {
            return EmptyStructures.EMPTY_OBJECT_ARRAY;
        }
        Iterator iterator = this.iterator();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (iterator.hasNext()) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length != this.size()) {
            throw new IllegalArgumentException("The expected array length is " + this.size());
        }
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        return objectArray;
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public String toString() {
        int n = this.size();
        if (n == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(16 * n);
        stringBuffer.append("{");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            stringBuffer.append(object == this ? "<" + this.getClassShortName() + ">" : object);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public abstract Iterator iterator();

    public abstract int size();
}

