/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import java.util.NoSuchElementException;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyIterator;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.ListIterator;
import org.ws4d.java.structures.UnsupportedOperationException;

class EmptyList
extends List {
    private static final ListIterator LIST_ITERATOR = new ListIteratorImpl();
    private static final String CANNOT_ADD = "Cannot add to this list.";
    private static final String CANNOT_REMOVE = "Cannot remove from this list.";
    private static final String CANNOT_MODIFY = "Cannot modify this list.";

    EmptyList() {
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException(CANNOT_ADD);
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException(CANNOT_REMOVE);
    }

    public boolean addAll(DataStructure dataStructure) {
        throw new UnsupportedOperationException(CANNOT_REMOVE);
    }

    public boolean addAll(int n, DataStructure dataStructure) {
        throw new UnsupportedOperationException(CANNOT_ADD);
    }

    public void clear() {
        throw new UnsupportedOperationException(CANNOT_REMOVE);
    }

    public boolean contains(Object object) {
        return false;
    }

    public boolean containsAll(DataStructure dataStructure) {
        return false;
    }

    public Object get(int n) {
        return null;
    }

    public int indexOf(Object object) {
        return -1;
    }

    public boolean isEmpty() {
        return true;
    }

    public Iterator iterator() {
        return EmptyStructures.EMPTY_ITERATOR;
    }

    public int lastIndexOf(Object object) {
        return -1;
    }

    public ListIterator listIterator() {
        return LIST_ITERATOR;
    }

    public ListIterator listIterator(int n) {
        return LIST_ITERATOR;
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException(CANNOT_REMOVE);
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException(CANNOT_REMOVE);
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException(CANNOT_MODIFY);
    }

    public int size() {
        return 0;
    }

    public List subList(int n, int n2) {
        return this;
    }

    public Object[] toArray() {
        return EmptyStructures.EMPTY_OBJECT_ARRAY;
    }

    public Object[] toArray(Object[] objectArray) {
        return EmptyStructures.EMPTY_OBJECT_ARRAY;
    }

    public String toString() {
        return "{}";
    }

    private static class ListIteratorImpl
    extends EmptyIterator
    implements ListIterator {
        private ListIteratorImpl() {
        }

        public void add(Object object) {
            throw new UnsupportedOperationException(EmptyList.CANNOT_ADD);
        }

        public boolean hasPrevious() {
            return false;
        }

        public int indexOfNext() {
            return 0;
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException(EmptyList.CANNOT_MODIFY);
        }
    }
}

