/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import java.util.NoSuchElementException;
import org.ws4d.java.structures.ConcurrentChangeException;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.util.WS4DIllegalStateException;

public class HashMap {
    private static final int MINIMAL_CAPACITY = 1;
    private static final int INITIAL_CAPACITY = 16;
    transient Entry[] buckets;
    transient int size;
    private transient int threshold;
    private final transient int loadFactor = 1;
    transient int mask;
    transient int changes = 0;
    transient Set entrySet;
    transient Set keySet;
    transient DataStructure values;

    public HashMap(int n) {
        if (n < 1) {
            n = 1;
        }
        this.init(n);
    }

    public HashMap() {
        this.init(16);
    }

    public HashMap(HashMap hashMap) {
        int n = hashMap.buckets.length;
        this.init(n);
        this.putAll(hashMap);
    }

    private static int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    void init(int n) {
        this.buckets = new Entry[n];
        this.size = 0;
        this.threshold = n * 1;
        this.mask = n - 1;
    }

    protected Entry addEntry(int n, int n2, Object object, Object object2) {
        Entry entry;
        Entry entry2 = this.buckets[n];
        this.buckets[n] = entry = this.createEntry(n2, object, object2, entry2);
        if (entry2 != null) {
            entry2.previous = entry;
        }
        ++this.changes;
        ++this.size;
        return entry;
    }

    protected Entry createEntry(int n, Object object, Object object2, Entry entry) {
        return new Entry(n, object, object2, null, entry);
    }

    public void clear() {
        ++this.changes;
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = null;
        }
        this.size = 0;
    }

    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    public boolean containsValue(Object object) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry entry = this.buckets[i];
            while (entry != null) {
                if (entry.value == object || entry.value != null && entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Entry entry = this.getEntry(object);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    Entry getEntry(Object object) {
        int n = object == null ? 0 : object.hashCode();
        return this.getEntry(n & this.mask, n, object);
    }

    Entry getEntry(int n, int n2, Object object) {
        Entry entry = this.buckets[n];
        while (entry != null) {
            if (entry.hash == n2 && (entry.key == object || entry.key.equals(object))) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object put(Object object, Object object2) {
        Entry entry;
        int n = 0;
        int n2 = 0;
        if (object != null) {
            n = object.hashCode();
            n2 = n & this.mask;
        }
        if ((entry = this.getEntry(n2, n, object)) != null) {
            Object object3 = entry.value;
            entry.value = object2;
            return object3;
        }
        if (this.size >= this.threshold) {
            this.resize(this.buckets.length << 2);
            return this.put(object, object2);
        }
        this.addEntry(n2, n, object, object2);
        return null;
    }

    public void putAll(HashMap hashMap) {
        int n = hashMap.size();
        if (n == 0) {
            return;
        }
        int n2 = this.size + n;
        if (n2 > this.threshold) {
            this.resize(HashMap.nextPowerOfTwo(n2 / 1 + 1));
        }
        Entry entry = null;
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private void putAll0(Entry[] entryArray) {
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry.next;
                int n = entry.hash & this.mask;
                entry.previous = null;
                Entry entry3 = this.buckets[n];
                if (entry3 != null) {
                    entry3.previous = entry;
                }
                entry.next = entry3;
                this.buckets[n] = entry;
                entry = entry2;
            }
        }
    }

    private void resize(int n) {
        Entry[] entryArray = this.buckets;
        this.buckets = new Entry[n];
        this.threshold = n * 1;
        this.mask = n - 1;
        this.putAll0(entryArray);
        ++this.changes;
    }

    public Object remove(Object object) {
        int n = 0;
        int n2 = 0;
        if (object != null) {
            n = object.hashCode();
            n2 = n & this.mask;
        }
        Entry entry = this.buckets[n2];
        while (entry != null) {
            if (entry.hash == n && (entry.key == object || entry.key.equals(object))) {
                this.removeEntry(n2, entry);
                Object object2 = entry.value;
                entry.value = null;
                return object2;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void removeEntry(int n, Entry entry) {
        Entry entry2 = entry.previous;
        Entry entry3 = entry.next;
        if (entry2 != null) {
            entry2.next = entry3;
        } else {
            this.buckets[n] = entry3;
        }
        if (entry3 != null) {
            entry3.previous = entry2;
        }
        entry.previous = null;
        entry.next = null;
        ++this.changes;
        --this.size;
    }

    public int size() {
        return this.size;
    }

    public Set entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    public Set keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
    }

    public DataStructure values() {
        return this.values != null ? this.values : (this.values = new Values());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof HashMap)) {
            return false;
        }
        HashMap hashMap = (HashMap)object;
        if (hashMap.size() != this.size()) {
            return false;
        }
        try {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                Object object2 = entry.getKey();
                Object object3 = entry.getValue();
                if (!hashMap.containsKey(object2)) {
                    return false;
                }
                Object object4 = hashMap.get(object2);
                if (!(object3 == null ? object4 != null : !object3.equals(object4))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public String toString() {
        int n = this.size();
        if (n == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(32 * n);
        stringBuffer.append("{");
        Iterator iterator = this.entrySet().iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            Entry entry = (Entry)iterator.next();
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            stringBuffer.append(object == this ? "<Map>" : object).append("=").append(object2 == this ? "<Map>" : object2);
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    protected class Values
    extends DataStructure {
        protected Values() {
        }

        public Iterator iterator() {
            return new AbstractMapIterator(){

                public Object next() {
                    return this.nextEntry().value;
                }
            };
        }

        public void clear() {
            HashMap.this.clear();
        }

        public boolean contains(Object object) {
            return HashMap.this.containsValue(object);
        }

        public int size() {
            return HashMap.this.size;
        }

        static /* synthetic */ HashMap access$200(Values values) {
            return values.HashMap.this;
        }
    }

    protected class KeySet
    extends Set {
        protected KeySet() {
        }

        public Iterator iterator() {
            return new AbstractMapIterator(){

                public Object next() {
                    return this.nextEntry().key;
                }
            };
        }

        public void clear() {
            HashMap.this.clear();
        }

        public boolean contains(Object object) {
            return HashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return HashMap.this.remove(object) != null;
        }

        public int size() {
            return HashMap.this.size;
        }

        static /* synthetic */ HashMap access$100(KeySet keySet) {
            return keySet.HashMap.this;
        }
    }

    protected class EntrySet
    extends Set {
        protected EntrySet() {
        }

        public Iterator iterator() {
            return new AbstractMapIterator(){

                public Object next() {
                    return this.nextEntry();
                }
            };
        }

        public void clear() {
            HashMap.this.clear();
        }

        public boolean contains(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                Object object2 = entry.getKey();
                int n = object2 == null ? 0 : object2.hashCode();
                Entry entry2 = HashMap.this.getEntry(n & HashMap.this.mask, n, object2);
                return entry.equals(entry2);
            }
            return false;
        }

        public boolean remove(Object object) {
            if (object instanceof Entry) {
                Entry entry;
                Entry entry2 = (Entry)object;
                Object object2 = entry2.getKey();
                int n = 0;
                int n2 = 0;
                if (object2 != null) {
                    n = object2.hashCode();
                    n2 = n & HashMap.this.mask;
                }
                if ((entry = HashMap.this.getEntry(n2, n, object2)) == null) {
                    return false;
                }
                if (entry.value == entry2.getValue() || entry.value != null && entry.value.equals(entry2.getValue())) {
                    HashMap.this.removeEntry(n2, entry);
                    return true;
                }
            }
            return false;
        }

        public int size() {
            return HashMap.this.size;
        }

        static /* synthetic */ HashMap access$000(EntrySet entrySet) {
            return entrySet.HashMap.this;
        }
    }

    public static class Entry {
        int hash;
        Object key;
        Object value;
        Entry previous;
        Entry next;

        Entry(int n, Object object, Object object2, Entry entry, Entry entry2) {
            this.hash = n;
            this.key = object;
            this.value = object2;
            this.previous = entry;
            this.next = entry2;
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final boolean equals(Object object) {
            Object object2;
            Object object3;
            Object object4;
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            Object object5 = this.getKey();
            return (object5 == (object4 = entry.getKey()) || object5 != null && object5.equals(object4)) && ((object3 = this.getValue()) == (object2 = entry.getValue()) || object3 != null && object3.equals(object2));
        }

        public final int hashCode() {
            return this.key.hashCode() ^ (this.value != null ? this.value.hashCode() : 0);
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    protected abstract class AbstractMapIterator
    implements Iterator {
        int currentBucketIndex = -1;
        private Entry current;
        int nextBucketIndex = -1;
        Entry next;
        int changesIt;

        AbstractMapIterator() {
            this.changesIt = HashMap.this.changes;
            this.nextBucket();
        }

        private final void nextBucket() {
            if (HashMap.this.size > 0) {
                while (++this.nextBucketIndex < HashMap.this.buckets.length && (this.next = HashMap.this.buckets[this.nextBucketIndex]) == null) {
                }
            }
        }

        public void remove() {
            this.checkChanges();
            if (this.current == null) {
                throw new WS4DIllegalStateException();
            }
            HashMap.this.removeEntry(this.currentBucketIndex, this.current);
            this.current = null;
            this.changesIt = HashMap.this.changes;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            this.checkChanges();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = this.current.next;
            this.currentBucketIndex = this.nextBucketIndex;
            if (this.next == null) {
                this.nextBucket();
            }
            return this.current;
        }

        final void checkChanges() {
            if (HashMap.this.changes != this.changesIt) {
                throw new ConcurrentChangeException();
            }
        }
    }
}

