/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import java.util.NoSuchElementException;
import org.ws4d.java.structures.ConcurrentChangeException;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.ListIterator;
import org.ws4d.java.util.WS4DIllegalStateException;

public class LinkedList
extends List {
    protected final Entry header;

    public LinkedList() {
        this.header.next = this.header = new Entry(null, null, null);
        this.header.previous = this.header;
    }

    public void add(int n, Object object) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + this.size);
        }
        Entry entry = this.getEntry(n);
        this.addPrevious(entry, object);
    }

    public boolean add(Object object) {
        this.addPrevious(this.header, object);
        return true;
    }

    public boolean addAll(DataStructure dataStructure) {
        if (dataStructure == null || dataStructure.size() == 0) {
            return false;
        }
        this.addPrevious(this.header, dataStructure);
        return true;
    }

    public boolean addAll(int n, DataStructure dataStructure) throws IndexOutOfBoundsException {
        if (dataStructure == null || dataStructure.size() == 0) {
            return false;
        }
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("index=" + n + ",size=" + this.size);
        }
        Entry entry = this.getEntry(n);
        this.addPrevious(entry, dataStructure);
        return true;
    }

    public void addFirst(Object object) {
        this.addPrevious(this.header.next, object);
    }

    public void clear() {
        ++this.changes;
        Entry entry = this.header.next;
        while (entry != this.header) {
            Entry entry2 = entry.next;
            entry.element = null;
            entry.next = null;
            entry.previous = null;
            entry = entry2;
        }
        this.header.previous = this.header;
        this.header.next = this.header;
        this.size = 0;
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("index=" + n + ", size=" + this.size);
        }
        return this.getEntry((int)n).element;
    }

    public Object getFirst() {
        return this.header.next.element;
    }

    public Object getLast() {
        return this.header.previous.element;
    }

    public Iterator iterator() {
        return new IteratorImpl();
    }

    public ListIterator listIterator(int n) throws IndexOutOfBoundsException {
        return new ListIteratorImpl(n);
    }

    public Object remove(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("index=" + n + ",size=" + this.size);
        }
        Entry entry = this.getEntry(n);
        this.removeEntry(entry);
        return entry.element;
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Entry entry = this.header.next;
        this.removeEntry(entry);
        return entry.element;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Entry entry = this.header.previous;
        this.removeEntry(entry);
        return entry.element;
    }

    public Object set(int n, Object object) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("index=" + n + ",size=" + this.size);
        }
        Entry entry = this.getEntry(n);
        return this.replaceEntry(object, entry);
    }

    public Object[] toArray() {
        return this.toArray(null);
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size;
        if (objectArray == null || objectArray.length < n) {
            objectArray = new Object[n];
        }
        Iterator iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }

    private void addPrevious(Entry entry, DataStructure dataStructure) {
        Entry entry2;
        ++this.changes;
        Entry entry3 = entry2 = entry.previous;
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            entry2.next = entry3 = new Entry(iterator.next(), entry2, entry);
            entry2 = entry3;
        }
        this.size += dataStructure.size();
        entry.previous = entry3;
    }

    private void addPrevious(Entry entry, Object object) {
        Entry entry2;
        ++this.changes;
        entry.previous.next = entry2 = new Entry(object, entry.previous, entry);
        entry.previous = entry2;
        ++this.size;
    }

    private Entry getEntry(int n) {
        if (this.size == 0 || this.size == n) {
            return this.header;
        }
        if (n < this.size >> 1) {
            Entry entry = this.header.next;
            for (int i = 0; i < n; ++i) {
                entry = entry.next;
            }
            return entry;
        }
        Entry entry = this.header;
        for (int i = this.size; i > n; --i) {
            entry = entry.previous;
        }
        return entry;
    }

    private void removeEntry(Entry entry) {
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        --this.size;
        ++this.changes;
    }

    private Object replaceEntry(Object object, Entry entry) {
        ++this.changes;
        Object object2 = entry.element;
        entry.element = object;
        return object2;
    }

    private class ListIteratorImpl
    extends IteratorImpl
    implements ListIterator {
        ListIteratorImpl(int n) {
            super(n);
        }

        public void add(Object object) {
            this.checkChanges();
            LinkedList.this.addPrevious(this.nextEntry, object);
            this.lastReturnedEntry = null;
            ++this.changesIt;
        }

        public boolean hasPrevious() {
            return this.nextEntry.previous != LinkedList.this.header;
        }

        public int indexOfNext() {
            return this.nextIndex;
        }

        public Object previous() {
            this.checkChanges();
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            this.lastReturnedEntry = this.nextEntry = this.nextEntry.previous;
            return this.lastReturnedEntry.element;
        }

        public void set(Object object) {
            this.checkChanges();
            if (this.lastReturnedEntry == null) {
                throw new WS4DIllegalStateException();
            }
            LinkedList.this.replaceEntry(object, this.lastReturnedEntry);
            ++this.changesIt;
        }
    }

    private class IteratorImpl
    implements Iterator {
        int nextIndex = 0;
        int changesIt;
        Entry lastReturnedEntry;
        Entry nextEntry;

        protected IteratorImpl() {
            this.changesIt = LinkedList.this.changes;
            this.lastReturnedEntry = null;
            this.nextEntry = LinkedList.this.header.next;
        }

        protected IteratorImpl(int n) throws IndexOutOfBoundsException {
            this.changesIt = LinkedList.this.changes;
            this.lastReturnedEntry = null;
            if (n < 0 || n > LinkedList.this.size) {
                throw new IndexOutOfBoundsException("nextIndex=" + n + ",size=" + LinkedList.this.size);
            }
            this.nextIndex = n;
            this.nextEntry = LinkedList.this.getEntry(n);
            this.changesIt = LinkedList.this.changes;
        }

        public boolean hasNext() {
            return this.nextEntry != LinkedList.this.header;
        }

        public Object next() {
            this.checkChanges();
            if (this.nextEntry == LinkedList.this.header) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            this.lastReturnedEntry = this.nextEntry;
            this.nextEntry = this.nextEntry.next;
            return this.lastReturnedEntry.element;
        }

        public void remove() {
            this.checkChanges();
            if (this.lastReturnedEntry == null) {
                throw new WS4DIllegalStateException();
            }
            LinkedList.this.removeEntry(this.lastReturnedEntry);
            if (this.nextEntry == this.lastReturnedEntry) {
                this.nextEntry = this.lastReturnedEntry.next;
            } else {
                --this.nextIndex;
            }
            this.lastReturnedEntry = null;
            ++this.changesIt;
        }

        protected final void checkChanges() {
            if (LinkedList.this.changes != this.changesIt) {
                throw new ConcurrentChangeException();
            }
        }
    }

    private static class Entry {
        protected Object element;
        protected Entry previous;
        protected Entry next;

        public Entry(Object object, Entry entry, Entry entry2) {
            this.element = object;
            this.previous = entry;
            this.next = entry2;
        }
    }
}

