/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import java.util.NoSuchElementException;
import org.ws4d.java.structures.ConcurrentChangeException;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.util.WS4DIllegalStateException;

public class LinkedMap
extends HashMap {
    boolean accessOrdering = false;
    Entry header;

    public LinkedMap() {
    }

    public LinkedMap(boolean bl) {
        this.accessOrdering = bl;
    }

    public LinkedMap(int n) {
        super(n);
    }

    public LinkedMap(int n, boolean bl) {
        super(n);
        this.accessOrdering = bl;
    }

    public LinkedMap(HashMap hashMap) {
        super(hashMap);
    }

    void init(int n) {
        super.init(n);
        this.header = new Entry();
    }

    protected HashMap.Entry addEntry(int n, int n2, Object object, Object object2) {
        Entry entry = (Entry)super.addEntry(n, n2, object, object2);
        this.header.addLinkedPrevious(entry);
        return entry;
    }

    protected HashMap.Entry createEntry(int n, Object object, Object object2, HashMap.Entry entry) {
        return new Entry(n, object, object2, null, entry);
    }

    protected void removeEntry(int n, HashMap.Entry entry) {
        super.removeEntry(n, entry);
        this.removeEntryFromLinking((Entry)entry);
    }

    private void removeEntryFromLinking(Entry entry) {
        entry.prevLinked.nextLinked = entry.nextLinked;
        entry.nextLinked.prevLinked = entry.prevLinked;
    }

    public void clear() {
        super.clear();
        this.header = new Entry();
    }

    public boolean containsValue(Object object) {
        if (object != null) {
            Entry entry = this.header.nextLinked;
            while (entry != this.header) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.nextLinked;
            }
        } else {
            Entry entry = this.header.nextLinked;
            while (entry != this.header) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.nextLinked;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Entry entry;
        int n = 0;
        int n2 = 0;
        if (object != null) {
            n = object.hashCode();
            n2 = n & this.mask;
        }
        if ((entry = (Entry)this.getEntry(n2, n, object)) != null) {
            if (this.accessOrdering) {
                this.doAccessOrdering(entry);
            }
            return entry.value;
        }
        return null;
    }

    public Object get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        Entry entry = this.getInternal(n);
        if (this.accessOrdering) {
            this.doAccessOrdering(entry);
        }
        return entry.value;
    }

    private void doAccessOrdering(Entry entry) {
        this.removeEntryFromLinking(entry);
        this.header.addLinkedPrevious(entry);
        ++this.changes;
    }

    private Entry getInternal(int n) {
        if (n < this.size >> 1) {
            Entry entry = this.header.nextLinked;
            for (int i = 0; i < n; ++i) {
                entry = entry.nextLinked;
            }
            return entry;
        }
        Entry entry = this.header;
        for (int i = this.size; i > n; --i) {
            entry = entry.prevLinked;
        }
        return entry;
    }

    public Object remove(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.remove(this.getInternal(n));
    }

    public Object removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("LinkedMap is empty");
        }
        return this.remove(this.header.nextLinked.key);
    }

    public Object removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("LinkedMap is empty");
        }
        return this.remove(this.header.prevLinked.key);
    }

    public Set entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    public Set keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
    }

    public DataStructure values() {
        return this.values != null ? this.values : (this.values = new Values());
    }

    private class Values
    extends HashMap.Values {
        private Values() {
        }

        public Iterator iterator() {
            return new AbstractLinkedMapIterator(){

                public Object next() {
                    return this.nextEntry().value;
                }
            };
        }

        static /* synthetic */ LinkedMap access$500(Values values) {
            return values.LinkedMap.this;
        }
    }

    private class KeySet
    extends HashMap.KeySet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new AbstractLinkedMapIterator(){

                public Object next() {
                    return this.nextEntry().key;
                }
            };
        }

        static /* synthetic */ LinkedMap access$400(KeySet keySet) {
            return keySet.LinkedMap.this;
        }
    }

    protected class EntrySet
    extends HashMap.EntrySet {
        protected EntrySet() {
        }

        public Iterator iterator() {
            return new AbstractLinkedMapIterator(){

                public Object next() {
                    return this.nextEntry();
                }
            };
        }

        static /* synthetic */ LinkedMap access$300(EntrySet entrySet) {
            return entrySet.LinkedMap.this;
        }
    }

    private abstract class AbstractLinkedMapIterator
    implements Iterator {
        Entry current;
        Entry nextLinked;
        int changesIt;

        AbstractLinkedMapIterator() {
            this.changesIt = LinkedMap.this.changes;
            this.current = LinkedMap.this.header;
            this.nextLinked = LinkedMap.this.header.nextLinked;
        }

        public void remove() {
            this.checkChanges();
            if (this.current == null || this.current == LinkedMap.this.header) {
                throw new WS4DIllegalStateException();
            }
            this.nextLinked = this.current.nextLinked;
            LinkedMap.this.remove(this.current.key);
            this.current = null;
            this.changesIt = LinkedMap.this.changes;
        }

        public boolean hasNext() {
            return this.nextLinked != LinkedMap.this.header;
        }

        Entry nextEntry() {
            this.checkChanges();
            if (this.nextLinked == LinkedMap.this.header) {
                throw new NoSuchElementException();
            }
            this.current = this.nextLinked;
            this.nextLinked = this.current.nextLinked;
            return this.current;
        }

        protected final void checkChanges() {
            if (LinkedMap.this.changes != this.changesIt) {
                throw new ConcurrentChangeException();
            }
        }
    }

    protected static class Entry
    extends HashMap.Entry {
        Entry prevLinked = null;
        Entry nextLinked = null;

        Entry(int n, Object object, Object object2, HashMap.Entry entry, HashMap.Entry entry2) {
            super(n, object, object2, entry, entry2);
        }

        Entry() {
            super(-1, null, null, null, null);
            this.prevLinked = this;
            this.nextLinked = this;
        }

        private void addLinkedPrevious(Entry entry) {
            entry.prevLinked = this.prevLinked;
            entry.nextLinked = this;
            this.prevLinked.nextLinked = entry;
            this.prevLinked = entry;
        }
    }
}

