/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import java.util.NoSuchElementException;
import org.ws4d.java.structures.ConcurrentChangeException;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ListIterator;
import org.ws4d.java.structures.UnsupportedOperationException;
import org.ws4d.java.util.WS4DIllegalStateException;

public abstract class List
extends DataStructure {
    private static final String CLASS_SHORT_NAME = "List";
    protected transient int changes = 0;
    transient int size = 0;

    public String getClassShortName() {
        return CLASS_SHORT_NAME;
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    public boolean addAll(DataStructure dataStructure) {
        boolean bl = false;
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.add(object);
            bl = true;
        }
        return bl;
    }

    public boolean addAll(int n, DataStructure dataStructure) {
        boolean bl = false;
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            this.add(n++, iterator.next());
            bl = true;
        }
        return bl;
    }

    public abstract Object get(int var1);

    public int indexOf(Object object) {
        if (object == null) {
            ListIterator listIterator = this.listIterator();
            while (listIterator.hasNext()) {
                if (listIterator.next() != null) continue;
                return listIterator.indexOfNext() - 1;
            }
        } else {
            ListIterator listIterator = this.listIterator();
            while (listIterator.hasNext()) {
                if (!object.equals(listIterator.next())) continue;
                return listIterator.indexOfNext() - 1;
            }
        }
        return -1;
    }

    public Iterator iterator() {
        return new IteratorImpl(0);
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            ListIterator listIterator = this.listIterator(this.size());
            while (listIterator.hasPrevious()) {
                if (listIterator.previous() != null) continue;
                return listIterator.indexOfNext();
            }
        } else {
            ListIterator listIterator = this.listIterator(this.size());
            while (listIterator.hasPrevious()) {
                if (!object.equals(listIterator.previous())) continue;
                return listIterator.indexOfNext();
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        return new ListIteratorImpl(n);
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.size;
    }

    public List subList(int n, int n2) {
        return new SubList(n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object object2 = listIterator.next();
            Object object3 = listIterator2.next();
            if (object2 != null ? object2.equals(object3) : object3 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    private final class SubList
    extends List {
        int offset;
        int size;

        SubList(int n, int n2) {
            this.offset = n;
            this.size = n2 - n;
        }

        public void add(int n, Object object) {
            List.this.add(n + this.offset, object);
            ++this.size;
        }

        public boolean addAll(DataStructure dataStructure) {
            return this.addAll(this.size, dataStructure);
        }

        public boolean addAll(int n, DataStructure dataStructure) {
            if (n < 0 || n > this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
            }
            int n2 = dataStructure.size();
            if (n2 == 0) {
                return false;
            }
            boolean bl = List.this.addAll(this.offset + n, dataStructure);
            this.size += n2;
            return bl;
        }

        public Object get(int n) {
            return List.this.get(n + this.offset);
        }

        public Iterator iterator() {
            return new IteratorImpl(0);
        }

        public ListIterator listIterator(int n) {
            return new ListIteratorImpl(n){

                public int indexOfNext() {
                    return super.indexOfNext() - SubList.this.offset;
                }
            };
        }

        public Object remove(int n) {
            Object object = List.this.remove(n + this.offset);
            --this.size;
            return object;
        }

        public Object set(int n, Object object) {
            return List.this.set(n + this.offset, object);
        }

        public int size() {
            return this.size;
        }

        public List subList(int n, int n2) {
            return new SubList(n + this.offset, n2 + this.offset);
        }
    }

    private class ListIteratorImpl
    extends IteratorImpl
    implements ListIterator {
        ListIteratorImpl(int n) {
            super(n);
        }

        public void add(Object object) {
            this.checkChanges();
            List.this.add(this.nextIndex++, object);
            this.currentIndex = -1;
            this.changesIt = List.this.changes;
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public int indexOfNext() {
            return this.nextIndex;
        }

        public Object previous() {
            this.checkChanges();
            try {
                int n = this.nextIndex - 1;
                Object object = List.this.get(n);
                this.currentIndex = this.nextIndex = n;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkChanges();
                throw new NoSuchElementException();
            }
        }

        public void set(Object object) {
            this.checkChanges();
            List.this.set(this.currentIndex, object);
        }
    }

    private class IteratorImpl
    implements Iterator {
        int nextIndex;
        int currentIndex = -1;
        int changesIt;

        IteratorImpl(int n) {
            this.changesIt = List.this.changes;
            this.nextIndex = n;
            this.changesIt = List.this.changes;
        }

        protected final void checkChanges() {
            if (List.this.changes != this.changesIt) {
                throw new ConcurrentChangeException();
            }
        }

        public boolean hasNext() {
            return this.nextIndex < List.this.size();
        }

        public Object next() {
            this.checkChanges();
            try {
                Object object = List.this.get(this.nextIndex);
                this.currentIndex = this.nextIndex++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkChanges();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            this.checkChanges();
            if (this.currentIndex == -1) {
                throw new WS4DIllegalStateException();
            }
            List.this.remove(this.currentIndex);
            if (this.currentIndex < this.nextIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
            this.changesIt = List.this.changes;
        }
    }
}

