/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.structures;

import org.ws4d.java.configuration.DispatchingProperties;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Set;
import org.ws4d.java.types.URI;

public class MessageIdBuffer {
    URI[] messageIds;
    Set uriSet;
    int pos = 0;
    int size = 0;

    public MessageIdBuffer() {
        this(DispatchingProperties.getInstance().getMessageIdBufferSize());
    }

    public MessageIdBuffer(int n) {
        this.messageIds = new URI[n];
        this.uriSet = new HashSet(n);
    }

    public synchronized boolean contains(URI uRI) {
        return this.uriSet.contains(uRI);
    }

    public synchronized boolean containsOrEnqueue(URI uRI) {
        if (uRI == null) {
            return false;
        }
        if (this.uriSet.contains(uRI)) {
            return true;
        }
        if (this.size == this.messageIds.length) {
            this.uriSet.remove(this.messageIds[this.pos]);
        } else {
            ++this.size;
        }
        this.uriSet.add(uRI);
        this.messageIds[this.pos] = uRI;
        this.pos = (this.pos + 1) % this.messageIds.length;
        return false;
    }

    public synchronized void clear() {
        this.uriSet.clear();
        for (int i = 0; i < this.messageIds.length; ++i) {
            this.messageIds[i] = null;
        }
        this.size = 0;
        this.pos = 0;
    }
}

