/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.MetadataMData;
import org.ws4d.java.types.ReferenceParametersMData;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.UnknownDataContainer;

public class EndpointReference
extends UnknownDataContainer {
    private AttributedURI address;
    private ReferenceParametersMData referenceParameters = null;
    private MetadataMData endpointMetadata = null;

    public EndpointReference(URI uRI) {
        this(uRI, null, null);
    }

    public EndpointReference(AttributedURI attributedURI) {
        this(attributedURI, null, null);
    }

    public EndpointReference(URI uRI, ReferenceParametersMData referenceParametersMData) {
        this(uRI, referenceParametersMData, null);
    }

    public EndpointReference(AttributedURI attributedURI, ReferenceParametersMData referenceParametersMData) {
        this(attributedURI, referenceParametersMData, null);
    }

    public EndpointReference(URI uRI, ReferenceParametersMData referenceParametersMData, MetadataMData metadataMData) {
        this(new AttributedURI(uRI), referenceParametersMData, metadataMData);
    }

    public EndpointReference(AttributedURI attributedURI, ReferenceParametersMData referenceParametersMData, MetadataMData metadataMData) {
        this.address = attributedURI;
        this.referenceParameters = referenceParametersMData;
        this.endpointMetadata = metadataMData;
    }

    public AttributedURI getAddress() {
        return this.address;
    }

    public ReferenceParametersMData getReferenceParameters() {
        return this.referenceParameters;
    }

    public MetadataMData getEndpointMetadata() {
        return this.endpointMetadata;
    }

    public boolean isXAddress() {
        if (this.address.isURN()) {
            return false;
        }
        String string = this.address.getSchema();
        if ("http".startsWith(string)) {
            return true;
        }
        if ("https".startsWith(string)) {
            return true;
        }
        return "soap.udp".startsWith(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EndpointReference [ address=").append(this.getAddress());
        stringBuffer.append(", referenceParameters=").append(this.getReferenceParameters());
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return 31 + (this.address == null ? 0 : this.address.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof EndpointReference)) {
            return false;
        }
        EndpointReference endpointReference = (EndpointReference)object;
        return !(this.address == null ? endpointReference.address != null : !this.address.equals(endpointReference.address));
    }

    public void setReferenceParameters(ReferenceParametersMData referenceParametersMData) {
        this.referenceParameters = referenceParametersMData;
    }
}

