/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.ScopeSet;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;

public class ProbeScopeSet
extends ScopeSet {
    public static final String SCOPE_MATCHING_RULE_RFC3986 = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/rfc3986";
    public static final String SCOPE_MATCHING_RULE_STRCMP0 = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/strcmp0";
    public static final String SCOPE_MATCHING_RULE_NONE = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/none";
    String matchBy;

    public ProbeScopeSet() {
        this((String)null);
    }

    public ProbeScopeSet(String string) {
        this(string, null);
    }

    public ProbeScopeSet(String string, String[] stringArray) {
        super(stringArray);
        this.matchBy = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ScopeSet [ matchBy=").append(this.matchBy);
        stringBuffer.append(", scopes=");
        if (this.strScopes != null) {
            Iterator iterator = this.strScopes.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
        }
        stringBuffer.append(", unknownAttributes=").append(this.unknownAttributes);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public String getMatchBy() {
        return this.matchBy;
    }

    public void setMatchBy(String string) {
        this.matchBy = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean containsAll(ScopeSet scopeSet) {
        if (scopeSet == null) {
            return true;
        }
        if (!(scopeSet instanceof ProbeScopeSet)) {
            return false;
        }
        ProbeScopeSet probeScopeSet = (ProbeScopeSet)scopeSet;
        if (SCOPE_MATCHING_RULE_NONE.equals(probeScopeSet.matchBy)) {
            return this.strScopes == null || this.strScopes.size() == 0;
        }
        if (probeScopeSet.isEmpty()) {
            return true;
        }
        if (this.strScopes == null && this.strScopes.size() <= 0) return false;
        if (probeScopeSet.matchBy == null || SCOPE_MATCHING_RULE_RFC3986.equals(probeScopeSet.matchBy)) {
            URISet uRISet = scopeSet.getScopesAsUris();
            Iterator iterator = uRISet.iterator();
            while (iterator.hasNext()) {
                URI uRI;
                Iterator iterator2;
                boolean bl = false;
                URI uRI2 = (URI)iterator.next();
                if (this.uriScopes == null) {
                    this.uriScopes = new URISet(this.strScopes.size());
                    iterator2 = this.strScopes.iterator();
                    while (iterator2.hasNext()) {
                        uRI = new URI((String)iterator2.next());
                        this.uriScopes.add(uRI);
                        if (!uRI2.equalsWsdRfc3986(uRI)) continue;
                        bl = true;
                        break;
                    }
                } else {
                    iterator2 = this.strScopes.iterator();
                    while (iterator2.hasNext()) {
                        uRI = new URI((String)iterator2.next());
                        this.uriScopes.add(uRI);
                        if (!uRI2.equalsWsdRfc3986(uRI)) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        if (!SCOPE_MATCHING_RULE_STRCMP0.equals(probeScopeSet.matchBy)) return false;
        Iterator iterator = scopeSet.strScopes.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string = (String)iterator.next();
            Iterator iterator3 = this.strScopes.iterator();
            while (iterator3.hasNext()) {
                String string2 = (String)iterator3.next();
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

