/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.structures.UnsupportedOperationException;
import org.ws4d.java.types.QName;

public class QNameSet {
    private Set qnames = null;
    private boolean readOnly = false;
    private int hashCode = 0;

    public QNameSet() {
        this.qnames = new HashSet();
    }

    public QNameSet(int n) {
        this.qnames = new HashSet(n);
    }

    public QNameSet(QName qName) {
        this.qnames = new HashSet(1);
        this.add(qName);
    }

    private QNameSet(Set set, boolean bl) {
        this.qnames = set;
        this.readOnly = bl;
    }

    public QNameSet(QNameSet qNameSet) {
        if (qNameSet == null) {
            this.qnames = new HashSet();
            return;
        }
        this.qnames = new HashSet(qNameSet.size());
        Iterator iterator = qNameSet.iterator();
        while (iterator.hasNext()) {
            this.add((QName)iterator.next());
        }
    }

    protected QNameSet(QName[] qNameArray) {
        this.qnames = new HashSet(qNameArray.length);
        for (int i = 0; i < qNameArray.length; ++i) {
            this.qnames.add(qNameArray[i]);
        }
    }

    public static QNameSet newInstanceReadOnly(Set set) {
        return new QNameSet(set, true);
    }

    public static QNameSet newInstance(Set set) {
        HashSet hashSet = new HashSet(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((DataStructure)hashSet).add(iterator.next());
        }
        return new QNameSet(hashSet, false);
    }

    public static QNameSet construct(String string) {
        QNameSet qNameSet = null;
        int n = 0;
        if (string != null) {
            qNameSet = new QNameSet(5);
            while (n < string.length()) {
                int n2 = string.indexOf(32, n);
                if (n2 == -1) {
                    n2 = string.length();
                }
                QName qName = QName.construct(string.substring(n, n2));
                qNameSet.add(qName);
                n = n2 + 1;
            }
        }
        return qNameSet;
    }

    public QName[] toArray() {
        QName[] qNameArray = new QName[this.qnames.size()];
        int n = 0;
        Iterator iterator = this.qnames.iterator();
        while (iterator.hasNext()) {
            qNameArray[n] = (QName)iterator.next();
            ++n;
        }
        return qNameArray;
    }

    public Iterator iterator() {
        if (this.readOnly) {
            return new ReadOnlyIterator(this.qnames);
        }
        return this.qnames.iterator();
    }

    public boolean contains(QName qName) {
        return this.qnames.contains(qName);
    }

    public boolean containsAll(QNameSet qNameSet) {
        if (qNameSet == null) {
            return true;
        }
        Iterator iterator = qNameSet.iterator();
        while (iterator.hasNext()) {
            if (this.qnames.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isContainedBy(Iterator iterator) {
        Iterator iterator2 = this.qnames.iterator();
        while (iterator2.hasNext()) {
            QName qName = (QName)iterator2.next();
            boolean bl = true;
            while (iterator.hasNext()) {
                QName qName2 = (QName)iterator.next();
                if (!qName2.equals(qName)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.qnames.size();
    }

    public String toString() {
        String string = new String();
        Iterator iterator = this.qnames.iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            string = string.concat(qName.toString() + " ");
        }
        return string.trim();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof QNameSet) {
            QNameSet qNameSet = (QNameSet)object;
            return this.qnames.equals(qNameSet.qnames);
        }
        return false;
    }

    public int hashCode() {
        if (!this.readOnly) {
            return this.qnames.hashCode();
        }
        int n = this.hashCode;
        if (n == 0) {
            this.hashCode = n = this.qnames.hashCode();
        }
        return n;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isEmpty() {
        return this.qnames.isEmpty();
    }

    public void add(QName qName) throws UnsupportedOperationException {
        if (this.readOnly) {
            throw new UnsupportedOperationException("QNameSet status is READ ONLY!");
        }
        if (qName != null) {
            this.qnames.add(qName);
        }
    }

    public void addAll(QNameSet qNameSet) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("QNameSet status is READ ONLY!");
        }
        if (qNameSet == null) {
            return;
        }
        Iterator iterator = qNameSet.iterator();
        while (iterator.hasNext()) {
            this.qnames.add(iterator.next());
        }
    }

    public boolean remove(QName qName) throws UnsupportedOperationException {
        if (this.readOnly) {
            throw new UnsupportedOperationException("QNameSet status is READ ONLY!");
        }
        return this.qnames.remove(qName);
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public static QName[] sortPrioritiesAsArray(QNameSet qNameSet) {
        if (qNameSet != null && qNameSet.size() > 0) {
            Iterator iterator = qNameSet.iterator();
            QName[] qNameArray = new QName[qNameSet.size()];
            int n = 0;
            while (iterator.hasNext()) {
                QName qName;
                qNameArray[n] = qName = (QName)iterator.next();
                ++n;
            }
            n = 0;
            while (n == 0) {
                n = 1;
                for (int i = 0; i < qNameArray.length - 1; ++i) {
                    QName qName = qNameArray[i];
                    QName qName2 = qNameArray[i + 1];
                    if (qName.getPriority() >= qName2.getPriority()) continue;
                    QName qName3 = qName2;
                    qNameArray[i + 1] = qName;
                    qNameArray[i] = qName3;
                    n = 0;
                }
            }
            return qNameArray;
        }
        return null;
    }

    public static QNameSet sortPriorities(QNameSet qNameSet) {
        return new QNameSet(QNameSet.sortPrioritiesAsArray(qNameSet));
    }
}

