/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.util;

import java.util.Random;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Math;

public final class IDGenerator {
    public static final String UUID_PREFIX = "uuid";
    public static final String URI_UUID_PREFIX = "urn:uuid:";
    private static final long CLOCK_OFFSET = 122192928000000000L;
    private static final String HEX_CHARS = "0123456789abcdef";
    private static final byte INDEX_CLOCK_HI = 6;
    private static final byte INDEX_CLOCK_MID = 4;
    private static final byte INDEX_CLOCK_LOW = 0;
    private static final byte INDEX_CLOCK_SEQUENCE = 8;
    private static final byte INDEX_VARIANT = 8;
    private static final byte INDEX_NODE = 10;
    private static byte[] nodeIdentifier = new byte[6];
    private static short clockSequence;
    private static long commonSequenceNumber;
    private static int lastUsedInternalMsgId;

    private IDGenerator() {
    }

    public static String getUUID() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(36);
        byte[] byArray = new byte[16];
        long l = System.currentTimeMillis();
        l *= 10000L;
        int n2 = (int)((l += 122192928000000000L) >>> 32);
        int n3 = (int)l;
        byArray[0] = (byte)(n3 >>> 24);
        byArray[1] = (byte)(n3 >>> 16);
        byArray[2] = (byte)(n3 >>> 8);
        byArray[3] = (byte)n3;
        byArray[6] = (byte)(n2 >>> 24);
        byArray[7] = (byte)(n2 >>> 16);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x10);
        byArray[4] = (byte)(n2 >>> 8);
        byArray[5] = (byte)n2;
        byArray[8] = (byte)(clockSequence >> 16);
        byArray[9] = (byte)clockSequence;
        clockSequence = (short)(clockSequence + 1);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0xFFFFFF80);
        for (n = 0; n < 6; ++n) {
            byArray[10 + n] = nodeIdentifier[n];
        }
        for (n = 0; n < 16; ++n) {
            switch (n) {
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    stringBuffer.append("-");
                }
            }
            int n4 = byArray[n] & 0xFF;
            stringBuffer.append(HEX_CHARS.charAt(n4 >> 4));
            stringBuffer.append(HEX_CHARS.charAt(n4 & 0xF));
        }
        return stringBuffer.toString();
    }

    public static URI getUUIDasURI() {
        return new URI(URI_UUID_PREFIX + IDGenerator.getUUID());
    }

    public static synchronized long getSequenceNumber() {
        return commonSequenceNumber++;
    }

    public static synchronized int getStaticMsgId() {
        return ++lastUsedInternalMsgId;
    }

    static {
        commonSequenceNumber = 1L;
        lastUsedInternalMsgId = 0;
        Random random = Math.getRandom();
        long l = random.nextLong();
        for (int i = 0; i < 6; ++i) {
            IDGenerator.nodeIdentifier[i] = (byte)(l >>> 56 - i * 8);
        }
        clockSequence = (short)(random.nextInt() & 0xFFFF);
    }
}

