/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.util.LogSubscriber;
import org.ws4d.java.util.Toolkit;

public final class Log {
    public static final int DEBUG_LAYER_ALL = Integer.MAX_VALUE;
    public static final int DEBUG_LAYER_FRAMEWORK = 4;
    public static final int DEBUG_LAYER_APPLICATION = 2;
    public static final int DEBUG_LAYER_COMMUNICATION = 1;
    public static final int DEBUG_LEVEL_DEBUG = 4;
    public static final int DEBUG_LEVEL_INFO = 3;
    public static final int DEBUG_LEVEL_WARN = 2;
    public static final int DEBUG_LEVEL_ERROR = 1;
    public static final int DEBUG_LEVEL_NO_LOGGING = 0;
    private static final String PREFIX_DEBUG = "DEBUG";
    private static final String PREFIX_INFO = "INFO ";
    private static final String PREFIX_WARN = "WARN ";
    private static final String PREFIX_ERROR = "ERROR";
    private static boolean showTimestamp = false;
    private static int logLevel = 4;
    private static int defaultLayers;
    private static int activeLayers;
    private static Vector subscribers;
    private static PrintStream out;
    private static PrintStream err;
    private static boolean logStackTrace;

    public static void setShowTimestamp(boolean bl) {
        showTimestamp = bl;
    }

    public static void setLogStackTrace(boolean bl) {
        logStackTrace = bl;
    }

    public static void setLogLevel(int n) {
        Log.setLogLevel(n, defaultLayers);
    }

    public static void setLogLevel(int n, int n2) {
        logLevel = n;
        activeLayers = n2;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static boolean isDebug() {
        return logLevel >= 4;
    }

    public static boolean isInfo() {
        return logLevel >= 3;
    }

    public static boolean isWarn() {
        return logLevel >= 2;
    }

    public static boolean isError() {
        return logLevel >= 1;
    }

    protected static String showTimestamp() {
        if (!showTimestamp) {
            return "";
        }
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(11);
        String string = (n < 10 ? "0" : "") + String.valueOf(n);
        n = calendar.get(12);
        String string2 = (n < 10 ? "0" : "") + String.valueOf(n);
        n = calendar.get(13);
        String string3 = (n < 10 ? "0" : "") + String.valueOf(n);
        n = calendar.get(14);
        String string4 = (n < 10 ? "00" : (n < 100 ? "0" : "")) + String.valueOf(n);
        return "|" + string + ":" + string2 + ":" + string3 + "." + string4;
    }

    public static void debug(String string) {
        Log.debug(string, Integer.MAX_VALUE);
    }

    public static void debug(String string, int n) {
        if ((n & activeLayers) == activeLayers || (n & activeLayers) == n) {
            Log.msgout(4, "[DEBUG" + Log.showTimestamp() + "] " + string);
        }
    }

    public static void info(String string) {
        Log.msgout(3, "[INFO " + Log.showTimestamp() + "] " + string);
    }

    public static void error(String string) {
        Log.msgout(1, "[ERROR" + Log.showTimestamp() + "] " + string);
    }

    public static void warn(String string) {
        Log.msgout(2, "[WARN " + Log.showTimestamp() + "] " + string);
    }

    protected static void msgout(int n, String string) {
        if (n <= logLevel) {
            if (n == 1 || n == 2) {
                err.println(string);
                err.flush();
            } else {
                out.println(string);
                out.flush();
            }
            Log.notifySubscribers(string);
        }
    }

    public static void printStackTrace(Throwable throwable) {
        if (logLevel != 0 && logStackTrace) {
            Toolkit toolkit = DPWSFramework.getToolkit();
            if (toolkit != null) {
                toolkit.printStackTrace(err, throwable);
            } else {
                throwable.printStackTrace();
            }
        }
    }

    public static String[] getStackTrace(Throwable throwable) {
        Toolkit toolkit = DPWSFramework.getToolkit();
        if (toolkit != null) {
            return toolkit.getStackTrace(throwable);
        }
        return null;
    }

    private static void notifySubscribers(String string) {
        Enumeration enumeration = subscribers.elements();
        while (enumeration.hasMoreElements()) {
            ((LogSubscriber)enumeration.nextElement()).notify(string);
        }
    }

    public static void subscribe(LogSubscriber logSubscriber) {
        subscribers.addElement(logSubscriber);
    }

    public static void unsubscribe(LogSubscriber logSubscriber) {
        subscribers.removeElement(logSubscriber);
    }

    public static void setNormalOutput(OutputStream outputStream) {
        out = new PrintStream(outputStream);
    }

    public static void setErrorOutput(OutputStream outputStream) {
        err = new PrintStream(outputStream);
    }

    static {
        activeLayers = defaultLayers = Integer.MAX_VALUE;
        subscribers = new Vector();
        out = System.out;
        err = System.err;
        logStackTrace = true;
    }
}

