/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.util;

import java.io.IOException;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.attachment.Attachment;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.AttachmentFactory;
import org.ws4d.java.attachment.IncomingAttachment;
import org.ws4d.java.attachment.OutgoingAttachment;
import org.ws4d.java.attachment.interfaces.incoming.IncomingFileAttachment;
import org.ws4d.java.communication.ContextID;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.service.parameter.AttachmentValue;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.parameter.QNameValue;
import org.ws4d.java.service.parameter.StringValue;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.QName;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.MIMEUtil;

public class ParameterUtil {
    public static String getAttributeValue(ParameterValue parameterValue, String string, String string2) {
        ParameterValue parameterValue2 = parameterValue.get(string);
        if (parameterValue2 == null) {
            return null;
        }
        return parameterValue2.getAttributeValue(string2);
    }

    public static void setAttributeValue(ParameterValue parameterValue, String string, String string2, String string3) {
        ParameterValue parameterValue2 = parameterValue.get(string);
        if (parameterValue2 == null) {
            return;
        }
        parameterValue2.setAttributeValue(string2, string3);
    }

    public static void setString(ParameterValue parameterValue, String string, String string2) {
        ParameterValue parameterValue2 = parameterValue.get(string);
        if (parameterValue2.getValueType() != 1) {
            throw new RuntimeException("Cannot set string value. Parameter is not a string.");
        }
        StringValue stringValue = (StringValue)parameterValue2;
        stringValue.set(string2);
    }

    public static String getString(ParameterValue parameterValue, String string) {
        ParameterValue parameterValue2 = parameterValue.get(string);
        if (parameterValue2.getValueType() == 1) {
            StringValue stringValue = (StringValue)parameterValue2;
            return stringValue.get();
        }
        return null;
    }

    public static boolean hasAttachment(ParameterValue parameterValue) {
        boolean bl = false;
        if (parameterValue.getValueType() == 2) {
            bl |= true;
        }
        Iterator iterator = parameterValue.children();
        while (iterator.hasNext() && !bl) {
            ParameterValue parameterValue2 = (ParameterValue)iterator.next();
            if (parameterValue2.getType() == SchemaUtil.getSchemaType(SchemaUtil.TYPE_BASE64_BINARY)) {
                // empty if block
            }
            if (parameterValue2.getValueType() == 2) {
                bl |= true;
            }
            bl |= ParameterUtil.hasAttachment(parameterValue2);
        }
        return bl;
    }

    public static void setAttachmentScope(ParameterValue parameterValue, ContextID contextID) {
        Object object;
        if (parameterValue.getValueType() == 2) {
            object = (AttachmentValue)parameterValue;
            ((AttachmentValue)object).setAttachmentScope(contextID);
        }
        object = parameterValue.getChildrenList();
        while (object.hasNext()) {
            ParameterValue parameterValue2 = (ParameterValue)object.next();
            ParameterUtil.setAttachmentScope(parameterValue2, contextID);
        }
    }

    public static List getAttachments(ParameterValue parameterValue) {
        LinkedList linkedList = new LinkedList();
        ParameterUtil.getAttachments(parameterValue, linkedList);
        return linkedList;
    }

    private static void getAttachments(ParameterValue parameterValue, List list) {
        Object object;
        Object object2;
        if (parameterValue.getValueType() == 2) {
            object2 = (AttachmentValue)parameterValue;
            object = ((AttachmentValue)object2).getAttachment();
            list.add(object);
        }
        object2 = parameterValue.getChildrenList();
        while (object2.hasNext()) {
            object = (ParameterValue)object2.next();
            ParameterUtil.getAttachments((ParameterValue)object, list);
        }
    }

    public static String getAttachmentFilename(ParameterValue parameterValue) {
        if (parameterValue.getValueType() == 2) {
            AttachmentValue attachmentValue = (AttachmentValue)parameterValue;
            IncomingFileAttachment incomingFileAttachment = (IncomingFileAttachment)attachmentValue.getAttachment();
            try {
                return incomingFileAttachment.getFilePath();
            }
            catch (AttachmentException attachmentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void removeAttachment(ParameterValue parameterValue) {
        if (parameterValue.getValueType() == 2) {
            AttachmentValue attachmentValue = (AttachmentValue)parameterValue;
            attachmentValue.setAttachment(null);
        }
    }

    public static void setAttachment(ParameterValue parameterValue, String string) {
        if (string == null) {
            return;
        }
        String string2 = MIMEUtil.estimateContentType(string);
        try {
            AttachmentFactory attachmentFactory = DPWSFramework.getAttachmentFactory();
            OutgoingAttachment outgoingAttachment = attachmentFactory.createFileAttachment(string, string2);
            ParameterUtil.setAttachment(parameterValue, null, outgoingAttachment);
        }
        catch (IOException iOException) {
            Log.error("Cannot set attachment. " + iOException.getMessage());
        }
    }

    public static IncomingAttachment getAttachment(ParameterValue parameterValue, String string) {
        ParameterValue parameterValue2 = parameterValue.get(string);
        if (parameterValue2.getValueType() == 2) {
            AttachmentValue attachmentValue = (AttachmentValue)parameterValue2;
            return attachmentValue.getAttachment();
        }
        return null;
    }

    public static void setAttachment(ParameterValue parameterValue, String string, Attachment attachment) {
        ParameterValue parameterValue2 = parameterValue.get(string);
        if (parameterValue2.getValueType() != 2) {
            throw new RuntimeException("Cannot set attachment value. Parameter is not a attachment.");
        }
        AttachmentValue attachmentValue = (AttachmentValue)parameterValue2;
        attachmentValue.setAttachment(attachment);
    }

    public static void setQName(ParameterValue parameterValue, String string, QName qName) {
        ParameterValue parameterValue2 = parameterValue.get(string);
        if (parameterValue2.getValueType() != 3) {
            throw new RuntimeException("Cannot set qualified name value. Parameter is not a qualified name.");
        }
        QNameValue qNameValue = (QNameValue)parameterValue2;
        qNameValue.set(qName);
    }

    public static QName getQName(ParameterValue parameterValue, String string) {
        ParameterValue parameterValue2 = parameterValue.get(string);
        if (parameterValue2.getValueType() == 3) {
            QNameValue qNameValue = (QNameValue)parameterValue2;
            return qNameValue.get();
        }
        return null;
    }
}

