/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.wsdl;

import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.types.AttributableSupport;
import org.ws4d.java.types.CustomAttributeValue;
import org.ws4d.java.types.QName;
import org.ws4d.java.wsdl.WSDL;
import org.ws4d.java.wsdl.WSDLMessage;
import org.ws4d.java.wsdl.WSDLOperation;
import org.ws4d.java.wsdl.WSDLPortType;

public class IOType
extends AttributableSupport {
    public static final String SUFFIX_INPUT = "Input";
    public static final String SUFFIX_OUTPUT = "Output";
    public static final String SUFFIX_FAULT = "Fault";
    public static final String REQUEST_SUFFIX = "";
    public static final String RESPONSE_SUFFIX = "Response";
    public static final String SOLICIT_SUFFIX = "Solicit";
    public static final String URL_DELIMITER = "/";
    public static final String URN_DELIMITER = ":";
    private WSDLOperation operation;
    private String name;
    private QName messageName;
    private String action;
    private boolean nameSet = false;
    private boolean actionSet = false;

    public IOType() {
        this((QName)null);
    }

    public IOType(QName qName) {
        this(null, qName);
    }

    public IOType(String string, QName qName) {
        this.name = string;
        this.messageName = qName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ name=").append(this.name);
        stringBuffer.append(", messageName=").append(this.messageName);
        stringBuffer.append(", action=").append(this.getAction());
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public void setAttribute(QName qName, CustomAttributeValue customAttributeValue) {
        super.setAttribute(qName, customAttributeValue);
        WSDL wSDL = this.getWsdl();
        if (wSDL != null) {
            wSDL.declareCustomAttributeNamespaces(qName, customAttributeValue);
        }
    }

    public void setAttributes(HashMap hashMap) {
        super.setAttributes(hashMap);
        WSDL wSDL = this.getWsdl();
        if (wSDL != null) {
            wSDL.declareCustomAttributeNamespaces(this);
        }
    }

    public WSDL getWsdl() {
        return this.operation == null ? null : this.operation.getWsdl();
    }

    public WSDLPortType getPortType() {
        return this.operation == null ? null : this.operation.getPortType();
    }

    public String getNamespace() {
        return this.operation == null ? null : this.operation.getNamespace();
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.generateDefaultName();
            this.nameSet = false;
        }
        return this.name;
    }

    public void setName(String string) {
        this.setNameInternal(string);
        if (string != null) {
            this.nameSet = true;
        }
    }

    public WSDLMessage getMessage() {
        WSDL wSDL = this.getWsdl();
        return wSDL == null ? null : wSDL.getMessage(this.messageName);
    }

    public DataStructure getParts() {
        WSDLMessage wSDLMessage = this.getMessage();
        return wSDLMessage == null ? EmptyStructures.EMPTY_STRUCTURE : wSDLMessage.getParts();
    }

    public QName getMessageName() {
        return this.messageName;
    }

    public void setMessage(QName qName) {
        this.messageName = qName;
    }

    public String getAction() {
        if (this.action == null) {
            this.action = this.generateDefaultAction();
            this.actionSet = false;
        }
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
        if (string != null) {
            this.actionSet = true;
        }
    }

    public WSDLOperation getOperation() {
        return this.operation;
    }

    void setOperation(WSDLOperation wSDLOperation) {
        this.operation = wSDLOperation;
    }

    void setNameInternal(String string) {
        this.name = string;
        if (!this.actionSet) {
            this.action = null;
        }
    }

    protected boolean isNameSet() {
        return this.nameSet;
    }

    boolean isActionSet() {
        return this.actionSet;
    }

    private String generateDefaultName() {
        WSDLOperation wSDLOperation = this.getOperation();
        if (wSDLOperation == null) {
            return null;
        }
        switch (wSDLOperation.getType()) {
            case 1: {
                if (wSDLOperation.getInput() != this) break;
                return wSDLOperation.getName();
            }
            case 4: {
                if (wSDLOperation.getOutput() != this) break;
                return wSDLOperation.getName();
            }
            case 2: {
                if (wSDLOperation.getInput() == this) {
                    return wSDLOperation.getName() + REQUEST_SUFFIX;
                }
                if (wSDLOperation.getOutput() != this) break;
                return wSDLOperation.getName() + RESPONSE_SUFFIX;
            }
            case 3: {
                if (wSDLOperation.getOutput() == this) {
                    return wSDLOperation.getName() + SOLICIT_SUFFIX;
                }
                if (wSDLOperation.getInput() != this) break;
                return wSDLOperation.getName() + RESPONSE_SUFFIX;
            }
        }
        return null;
    }

    private String generateDefaultAction() {
        WSDL wSDL = this.getWsdl();
        if (wSDL == null) {
            return REQUEST_SUFFIX;
        }
        String string = wSDL.getTargetNamespace();
        if (string == null || REQUEST_SUFFIX.equals(string)) {
            return REQUEST_SUFFIX;
        }
        WSDLPortType wSDLPortType = this.getPortType();
        if (wSDLPortType == null) {
            return REQUEST_SUFFIX;
        }
        String string2 = this.getName();
        if (string2 == null || REQUEST_SUFFIX.equals(string2)) {
            return REQUEST_SUFFIX;
        }
        String string3 = URL_DELIMITER;
        if (string.startsWith("urn")) {
            string3 = URN_DELIMITER;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (!string.endsWith(string3)) {
            stringBuffer.append(string3);
        }
        stringBuffer.append(wSDLPortType.getLocalName());
        stringBuffer.append(string3);
        WSDLOperation wSDLOperation = this.getOperation();
        if (wSDLOperation.getFault(this.name) != null) {
            stringBuffer.append(wSDLOperation.getName());
            stringBuffer.append(string3);
            stringBuffer.append(SUFFIX_FAULT);
            stringBuffer.append(string3);
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

