/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.wsdl;

import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedMap;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.AttributableSupport;
import org.ws4d.java.types.CustomAttributeValue;
import org.ws4d.java.types.QName;
import org.ws4d.java.wsdl.IOType;
import org.ws4d.java.wsdl.WSDL;
import org.ws4d.java.wsdl.WSDLMessage;
import org.ws4d.java.wsdl.WSDLPortType;

public class WSDLOperation
extends AttributableSupport {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_ONE_WAY = 1;
    public static final int TYPE_REQUEST_RESPONSE = 2;
    public static final int TYPE_SOLICIT_RESPONSE = 3;
    public static final int TYPE_NOTIFICATION = 4;
    private WSDLPortType portType;
    private String name;
    private int type;
    private int derivedType;
    private IOType input;
    private IOType output;
    private HashMap faults;

    public static String typeToString(int n) {
        switch (n) {
            case 1: {
                return "One-Way";
            }
            case 2: {
                return "Request-Response";
            }
            case 3: {
                return "Solicit-Response";
            }
            case 4: {
                return "Notification";
            }
        }
        return "Unknown";
    }

    public WSDLOperation() {
        this((String)null);
    }

    public WSDLOperation(String string) {
        this.derivedType = this.type = -1;
        this.input = null;
        this.output = null;
        this.name = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ name=").append(this.name);
        stringBuffer.append(", type=").append(this.getTypeAsString());
        stringBuffer.append(", input=").append(this.input);
        stringBuffer.append(", output=").append(this.output);
        stringBuffer.append(", faults=").append(this.faults);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public void setAttribute(QName qName, CustomAttributeValue customAttributeValue) {
        super.setAttribute(qName, customAttributeValue);
        WSDL wSDL = this.getWsdl();
        if (wSDL != null) {
            wSDL.declareCustomAttributeNamespaces(qName, customAttributeValue);
        }
    }

    public void setAttributes(HashMap hashMap) {
        super.setAttributes(hashMap);
        WSDL wSDL = this.getWsdl();
        if (wSDL != null) {
            wSDL.declareCustomAttributeNamespaces(this);
        }
    }

    public WSDL getWsdl() {
        return this.portType == null ? null : this.portType.getWsdl();
    }

    public DataStructure getInputParts() {
        return this.input == null ? EmptyStructures.EMPTY_STRUCTURE : this.input.getParts();
    }

    public DataStructure getOutputParts() {
        return this.output == null ? EmptyStructures.EMPTY_STRUCTURE : this.output.getParts();
    }

    public DataStructure getFaultParts(String string) {
        IOType iOType = this.getFault(string);
        return iOType == null ? EmptyStructures.EMPTY_STRUCTURE : iOType.getParts();
    }

    public WSDLMessage getInputMessage() {
        return this.input == null ? null : this.input.getMessage();
    }

    public WSDLMessage getOutputMessage() {
        return this.output == null ? null : this.output.getMessage();
    }

    public DataStructure getFaultMessages() {
        if (this.faults == null || !this.isBidirectional()) {
            return EmptyStructures.EMPTY_STRUCTURE;
        }
        ArrayList arrayList = new ArrayList(this.faults.size());
        Iterator iterator = this.faults.values().iterator();
        while (iterator.hasNext()) {
            IOType iOType = (IOType)iterator.next();
            WSDLMessage wSDLMessage = iOType.getMessage();
            if (wSDLMessage == null) continue;
            ((List)arrayList).add(wSDLMessage);
        }
        return arrayList;
    }

    public WSDLMessage getFaultMessage(String string) {
        IOType iOType = this.getFault(string);
        return iOType == null ? null : iOType.getMessage();
    }

    public String getInputName() {
        return this.input == null ? null : this.input.getName();
    }

    public String getOutputName() {
        return this.output == null ? null : this.output.getName();
    }

    public String getNamespace() {
        return this.portType == null ? null : this.portType.getNamespace();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getType() {
        return this.type == -1 ? (this.derivedType == -1 ? this.deriveType() : this.derivedType) : this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getTypeAsString() {
        return WSDLOperation.typeToString(this.getType());
    }

    public boolean isRequest() {
        int n = this.getType();
        return n == 1 || n == 2;
    }

    public boolean isEvented() {
        if (this.portType != null && !this.portType.isEventSource()) {
            return false;
        }
        int n = this.getType();
        return n == 4 || n == 3;
    }

    public boolean isBidirectional() {
        int n = this.getType();
        return n == 2 || n == 3;
    }

    public String getInputAction() {
        return this.input == null ? null : this.input.getAction();
    }

    public String getOutputAction() {
        return this.output == null ? null : this.output.getAction();
    }

    public HashMap getFaultActions() {
        if (this.faults == null || !this.isBidirectional()) {
            return EmptyStructures.EMPTY_MAP;
        }
        LinkedMap linkedMap = new LinkedMap(this.faults.size());
        Iterator iterator = this.faults.values().iterator();
        while (iterator.hasNext()) {
            IOType iOType = (IOType)iterator.next();
            linkedMap.put(iOType.getName(), iOType.getAction());
        }
        return linkedMap;
    }

    public IOType getInput() {
        return this.input;
    }

    public void setInput(IOType iOType) {
        this.derivedType = this.output == null ? 1 : 3;
        this.input = iOType;
        iOType.setOperation(this);
        WSDL wSDL = this.getWsdl();
        if (wSDL != null) {
            wSDL.declareCustomAttributeNamespaces(iOType);
        }
    }

    public IOType getOutput() {
        return this.output;
    }

    public void setOutput(IOType iOType) {
        this.derivedType = this.input == null ? 4 : 2;
        this.output = iOType;
        iOType.setOperation(this);
        WSDL wSDL = this.getWsdl();
        if (wSDL != null) {
            wSDL.declareCustomAttributeNamespaces(iOType);
        }
    }

    public DataStructure getFaults() {
        return this.faults == null || !this.isBidirectional() ? EmptyStructures.EMPTY_STRUCTURE : new ArrayList(this.faults.values());
    }

    public IOType getFault(String string) {
        return this.faults == null || !this.isBidirectional() ? null : (IOType)this.faults.get(string);
    }

    public void addFault(IOType iOType) {
        if (iOType == null) {
            return;
        }
        if (this.faults == null) {
            this.faults = new LinkedMap();
        }
        this.faults.put(iOType.getName(), iOType);
        iOType.setOperation(this);
        WSDL wSDL = this.getWsdl();
        if (wSDL != null) {
            wSDL.declareCustomAttributeNamespaces(iOType);
        }
    }

    public WSDLPortType getPortType() {
        return this.portType;
    }

    void setPortType(WSDLPortType wSDLPortType) {
        this.portType = wSDLPortType;
    }

    private int deriveType() {
        this.derivedType = this.input == null ? (this.output == null ? -1 : 4) : (this.output == null ? 1 : -1);
        return this.derivedType;
    }
}

