/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.monitor.ResourceLoader;
import org.ws4d.java.io.fs.FileSystem;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaException;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.wsdl.WSDL;
import org.ws4d.java.wsdl.WSDLPortType;
import org.xmlpull.v1.XmlPullParserException;

public class WSDLRepository {
    public static final boolean DEMO_MODE = false;
    private static final String DEMO_WSDL_COMMON = "OSAmICommonSensorService.wsdl";
    private static final String DEMO_WSDL_PULSE = "OSAmIPulseService.wsdl";
    private static final String DEMO_WSDL_O2 = "OSAmISpO2Service.wsdl";
    private static final String REPO_PATH = "wsdl_repo";
    private static final String INDEX_FILE = "index.idx";
    private static final int READ_BUFFER_SIZE = 1024;
    private static final WSDLRepository INSTANCE = new WSDLRepository();
    private final FileSystem fs;
    private final HashMap index;

    public static String getRepoPath() {
        return REPO_PATH;
    }

    public static WSDLRepository getInstance() {
        return INSTANCE;
    }

    public static WSDL loadWsdl(URI uRI) throws IOException {
        try {
            return WSDL.parse(uRI, true);
        }
        catch (IOException iOException) {
            Log.error("Unable to obtain WSDL from " + uRI + ": " + iOException.getMessage());
            throw iOException;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Log.error("Ill formatted WSDL from " + uRI + ": " + xmlPullParserException.getMessage());
            throw new IOException(xmlPullParserException.getMessage());
        }
    }

    private WSDLRepository() {
        block5: {
            this.index = new HashMap();
            FileSystem fileSystem = null;
            try {
                fileSystem = DPWSFramework.getLocalFileSystem();
            }
            catch (IOException iOException) {
                Log.error("No local file system available, WSDL repository will not work.");
            }
            this.fs = fileSystem;
            if (fileSystem != null) {
                try {
                    this.loadIndex();
                }
                catch (IOException iOException) {
                    if (!Log.isDebug()) break block5;
                    Log.debug("Unable to load WSDL Repository index file: " + iOException.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getWsdlInputStream(QName qName) {
        String string;
        if (this.fs == null) {
            return null;
        }
        HashMap hashMap = this.index;
        synchronized (hashMap) {
            string = (String)this.index.get(qName);
        }
        if (string == null) {
            return null;
        }
        try {
            return this.fs.readFile(string);
        }
        catch (IOException iOException) {
            Log.error("Unable to read WSDL file " + string + ": " + iOException.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSDL getWsdl(QName qName) {
        try {
            InputStream inputStream = this.getWsdlInputStream(qName);
            if (inputStream == null) {
                return null;
            }
            WSDL wSDL = WSDL.parse(inputStream, true);
            inputStream.close();
            if (Log.isDebug()) {
                Log.debug("WSDL: " + wSDL.toString(), 4);
            }
            return wSDL;
        }
        catch (XmlPullParserException xmlPullParserException) {
            HashMap hashMap = this.index;
            synchronized (hashMap) {
                Log.error("Ill formatted WSDL file " + this.index.get(qName) + ": " + xmlPullParserException.getMessage());
            }
        }
        catch (IOException iOException) {
            HashMap hashMap = this.index;
            synchronized (hashMap) {
                Log.error("Unable to read WSDL file " + this.index.get(qName) + ": " + iOException.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getSchema(String string, String string2) {
        block13: {
            String string3;
            Object object;
            Object object2 = this.index;
            synchronized (object2) {
                object = string2 == null ? string : string + '|' + string2;
                string3 = (String)this.index.get(object);
                if (string3 == null) {
                    if (Log.isDebug()) {
                        Log.debug("Unable to find XML Schema for schema location " + string + " and namespace " + string2 + " within WSDL Repository");
                    }
                    return null;
                }
            }
            object2 = this.fs.readFile(string3);
            if (object2 == null) {
                Log.warn("Unable to read XML Schema file " + string3);
                return null;
            }
            try {
                object = Schema.parse((InputStream)object2, null, true);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)object2).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Log.error("Unable to read XML Schema file " + string3 + ": " + iOException.getMessage());
                    break block13;
                }
                catch (XmlPullParserException xmlPullParserException) {
                    Log.error("Ill formatted XML Schema file " + string3 + ": " + xmlPullParserException.getMessage());
                    break block13;
                }
                catch (SchemaException schemaException) {
                    Log.error("Invalid XML Schema file " + string3 + ": " + schemaException.getMessage());
                }
            }
            ((InputStream)object2).close();
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getPortTypes() {
        HashMap hashMap = this.index;
        synchronized (hashMap) {
            if (this.index.isEmpty()) {
                return EmptyStructures.EMPTY_ITERATOR;
            }
            HashSet hashSet = new HashSet();
            Iterator iterator = this.index.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof QName)) continue;
                ((DataStructure)hashSet).add(object);
            }
            return ((DataStructure)hashSet).iterator();
        }
    }

    public WSDL loadAndStore(URI uRI, String string) throws IOException {
        this.store(uRI, string);
        if (string == null) {
            string = uRI.toString();
        } else if ("".equals(string)) {
            return WSDLRepository.loadWsdl(uRI);
        }
        return this.getWSDL(string);
    }

    public WSDL loadAndStore(InputStream inputStream, String string) throws IOException {
        WSDL wSDL = null;
        try {
            wSDL = WSDL.parse(inputStream, true);
            inputStream.close();
            if (wSDL != null) {
                this.store(wSDL, string);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            Log.error("Ill formatted WSDL file: " + xmlPullParserException.getMessage());
        }
        return wSDL;
    }

    public WSDL loadAndStore(URI uRI) throws IOException {
        return this.loadAndStore(uRI, uRI.toString());
    }

    public void store(WSDL wSDL, String string) {
        String string2 = REPO_PATH + this.fs.fileSeparator() + this.fs.escapeFileName(string);
        try {
            OutputStream outputStream = this.fs.writeFile(string2);
            wSDL.serialize(outputStream);
            outputStream.close();
            this.index(wSDL, string2);
            this.flushIndex();
        }
        catch (IOException iOException) {
            Log.error("Unable to write to WSDL file " + string2 + ": " + iOException.getMessage());
        }
    }

    public void store(URI uRI, String string) throws IOException {
        this.store(uRI, string, true);
    }

    private void store(URI uRI, String string, boolean bl) throws IOException {
        int n;
        if (Log.isDebug()) {
            Log.debug("Importing WSDL from " + uRI);
        }
        WSDL wSDL = null;
        if (string == null) {
            string = uRI.toString();
        } else if ("".equals(string)) {
            try {
                wSDL = WSDL.parse(uRI, false);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new IOException(xmlPullParserException.getMessage());
            }
            string = wSDL.getTargetNamespace();
            if (!string.endsWith("/")) {
                string = string + '/';
            }
            string = string + "description.wsdl";
        }
        String string2 = REPO_PATH + this.fs.fileSeparator() + this.fs.escapeFileName(string);
        if (this.fs.fileExists(string2)) {
            if (Log.isDebug()) {
                Log.debug("WSDL Repository resource already exists: " + string2);
            }
            return;
        }
        ResourceLoader resourceLoader = DPWSFramework.getResourceAsStream(uRI);
        InputStream inputStream = resourceLoader.getInputStream();
        if (inputStream == null) {
            throw new IOException("Unable to read from " + uRI);
        }
        OutputStream outputStream = this.fs.writeFile(string2);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
        if (wSDL == null) {
            try {
                wSDL = WSDL.parse(uRI, false);
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new IOException(xmlPullParserException.getMessage());
            }
        }
        this.index(wSDL, string2);
        this.storeReferencedFiles(uRI, string, bl, wSDL);
    }

    private void storeReferencedFiles(URI uRI, String string, boolean bl, WSDL wSDL) throws IOException {
        Object object;
        Object object2;
        URI uRI2 = new URI(string);
        Iterator iterator = wSDL.getImports().values().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = URI.absolutize(uRI, (String)object2);
            this.store((URI)object, URI.absolutize(uRI2, (String)object2).toString(), false);
        }
        iterator = wSDL.getTypes();
        while (iterator.hasNext()) {
            URI uRI3;
            String string2;
            object2 = (Schema)iterator.next();
            object = ((Schema)object2).getIncludes().iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                uRI3 = URI.absolutize(uRI, string2);
                this.storeSchema(uRI3, URI.absolutize(uRI2, string2).toString(), string2, false);
            }
            object = ((Schema)object2).getImports().values().iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                uRI3 = URI.absolutize(uRI, string2);
                this.storeSchema(uRI3, URI.absolutize(uRI2, string2).toString(), string2, false);
            }
        }
        if (bl) {
            this.flushIndex();
        }
    }

    public void storeSchema(URI uRI, String string) throws IOException {
        this.storeSchema(uRI, string, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSchema(URI uRI, String string, String string2, boolean bl) throws IOException {
        URI uRI2;
        String string3;
        Object object;
        int n;
        if (Log.isDebug()) {
            Log.debug("Importing XML Schema from " + uRI);
        }
        Schema schema = null;
        if (string == null) {
            string = uRI.toString();
        } else if ("".equals(string)) {
            try {
                schema = Schema.parse(uRI, false);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            string = schema.getTargetNamespace();
        }
        String string4 = REPO_PATH + this.fs.fileSeparator() + this.fs.escapeFileName(string);
        if (this.fs.fileExists(string4)) {
            if (Log.isDebug()) {
                Log.debug("WSDL Repository resource already exists: " + string4);
            }
            return;
        }
        ResourceLoader resourceLoader = DPWSFramework.getResourceAsStream(uRI);
        InputStream inputStream = resourceLoader.getInputStream();
        if (inputStream == null) {
            throw new IOException("Unable to read from " + uRI);
        }
        OutputStream outputStream = this.fs.writeFile(string4);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
        if (schema == null) {
            try {
                schema = Schema.parse(uRI, false);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        Object object2 = this.index;
        synchronized (object2) {
            object = schema.getTargetNamespace();
            if (object != null) {
                this.index.put(string2 + '|' + (String)object, string4);
            } else {
                this.index.put(string2, string4);
            }
        }
        object2 = new URI(string);
        object = schema.getIncludes().iterator();
        while (object.hasNext()) {
            string3 = (String)object.next();
            uRI2 = URI.absolutize(uRI, string3);
            this.storeSchema(uRI2, URI.absolutize((URI)object2, string3).toString(), string3, false);
        }
        object = schema.getImports().values().iterator();
        while (object.hasNext()) {
            string3 = (String)object.next();
            uRI2 = URI.absolutize(uRI, string3);
            this.storeSchema(uRI2, URI.absolutize((URI)object2, string3).toString(), string3, false);
        }
        if (bl) {
            this.flushIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSDL getWSDL(String string) {
        String string2 = REPO_PATH + this.fs.fileSeparator() + this.fs.escapeFileName(string);
        try {
            InputStream inputStream = this.fs.readFile(string2);
            try {
                WSDL wSDL;
                WSDL wSDL2 = wSDL = WSDL.parse(inputStream, true);
                return wSDL2;
            }
            catch (IOException iOException) {
                Log.error("Unable to read WSDL file " + string2 + ": " + iOException.getMessage());
                return null;
            }
            catch (XmlPullParserException xmlPullParserException) {
                Log.error("Ill formatted WSDL file " + string2 + ": " + xmlPullParserException.getMessage());
                return null;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            if (!Log.isDebug()) return null;
            Log.debug("WSDL file not found within WSDL Repository: " + string2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(QName qName) {
        HashMap hashMap = this.index;
        synchronized (hashMap) {
            String string = (String)this.index.get(qName);
            if (string != null) {
                this.fs.deleteFile(string);
                this.index.remove(qName);
                try {
                    this.flushIndex();
                }
                catch (IOException iOException) {
                    Log.warn("Unable to write WSDL Repository index file: " + iOException.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap hashMap = this.index;
        synchronized (hashMap) {
            Iterator iterator = this.index.values().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.fs.deleteFile(string);
            }
            this.fs.deleteFile(REPO_PATH + this.fs.fileSeparator() + INDEX_FILE);
            this.index.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void index(WSDL wSDL, String string) {
        HashMap hashMap = this.index;
        synchronized (hashMap) {
            Iterator iterator = wSDL.getPortTypes();
            while (iterator.hasNext()) {
                WSDLPortType wSDLPortType = (WSDLPortType)iterator.next();
                this.index.put(wSDLPortType.getName(), string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndex() throws IOException {
        HashMap hashMap = this.index;
        synchronized (hashMap) {
            InputStream inputStream = this.fs.readFile(REPO_PATH + this.fs.fileSeparator() + INDEX_FILE);
            if (inputStream == null) {
                if (Log.isDebug()) {
                    Log.debug("No WSDL Repository index file available.");
                }
                return;
            }
            try {
                int n;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                StringBuffer stringBuffer = new StringBuffer(64);
                block19: while ((n = ((Reader)inputStreamReader).read()) != -1) {
                    int n2;
                    switch (n) {
                        case 115: 
                        case 119: {
                            n2 = n;
                            break;
                        }
                        case 10: {
                            continue block19;
                        }
                        default: {
                            while ((n = ((Reader)inputStreamReader).read()) != -1 && n != 10) {
                            }
                            continue block19;
                        }
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(64);
                    } else if (stringBuffer.length() > 0) {
                        stringBuffer.delete(0, stringBuffer.length());
                    }
                    while ((n = ((Reader)inputStreamReader).read()) != -1 && n != 61 && n != 10) {
                        stringBuffer.append((char)n);
                    }
                    switch (n) {
                        case -1: {
                            Log.warn("Unexpected end of stream while reading WSDL Repository index file.");
                            return;
                        }
                        case 10: {
                            Log.warn("Unexpected end of line while reading WSDL Repository index file. Buffer contents: " + stringBuffer);
                            continue block19;
                        }
                    }
                    String string = stringBuffer.toString();
                    if (stringBuffer.length() > 0) {
                        stringBuffer.delete(0, stringBuffer.length());
                    }
                    while ((n = ((Reader)inputStreamReader).read()) != -1 && n != 10) {
                        stringBuffer.append((char)n);
                    }
                    switch (n2) {
                        case 119: {
                            int n3 = string.indexOf(125);
                            String string2 = null;
                            if (n3 != -1) {
                                string2 = string.substring(string.charAt(0) == '{' ? 1 : 0, n3);
                                string = string.substring(n3 + 1);
                            }
                            QName qName = new QName(string, string2);
                            this.index.put(qName, stringBuffer.toString());
                            break;
                        }
                        case 115: {
                            this.index.put(string, stringBuffer.toString());
                        }
                    }
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIndex() throws IOException {
        HashMap hashMap = this.index;
        synchronized (hashMap) {
            if (this.index.isEmpty()) {
                return;
            }
            OutputStream outputStream = this.fs.writeFile(REPO_PATH + this.fs.fileSeparator() + INDEX_FILE);
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                Iterator iterator = this.index.entrySet().iterator();
                while (iterator.hasNext()) {
                    HashMap.Entry entry = (HashMap.Entry)iterator.next();
                    Object object = entry.getKey();
                    if (object instanceof QName) {
                        ((Writer)outputStreamWriter).write(119);
                    } else {
                        ((Writer)outputStreamWriter).write(115);
                    }
                    outputStreamWriter.write(object.toString());
                    ((Writer)outputStreamWriter).write(61);
                    outputStreamWriter.write(entry.getValue().toString());
                    ((Writer)outputStreamWriter).write(10);
                }
                ((Writer)outputStreamWriter).flush();
                ((Writer)outputStreamWriter).close();
                outputStream.flush();
                if (Log.isDebug()) {
                    Log.debug("Flushing WSDL Repository index file done.");
                }
            }
            finally {
                outputStream.close();
            }
        }
    }
}

