/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.wsdl;

import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedMap;
import org.ws4d.java.structures.List;
import org.ws4d.java.types.QName;
import org.ws4d.java.wsdl.NamedItem;
import org.ws4d.java.wsdl.WSDL;
import org.ws4d.java.wsdl.WSDLPort;
import org.ws4d.java.wsdl.WSDLPortType;

public class WSDLService
extends NamedItem {
    private WSDL wsdl;
    private HashMap ports;

    public WSDLService() {
        this(null);
    }

    public WSDLService(QName qName) {
        super(qName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        stringBuffer.append(super.toString());
        stringBuffer.append(", ports=").append(this.ports);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public DataStructure getOperations() {
        if (this.ports == null) {
            return EmptyStructures.EMPTY_STRUCTURE;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.ports.values().iterator();
        while (iterator.hasNext()) {
            WSDLPort wSDLPort = (WSDLPort)iterator.next();
            arrayList.addAll(wSDLPort.getOperations());
        }
        return arrayList;
    }

    public DataStructure getPortTypes() {
        if (this.ports == null) {
            return EmptyStructures.EMPTY_STRUCTURE;
        }
        ArrayList arrayList = new ArrayList(this.ports.size());
        Iterator iterator = this.ports.values().iterator();
        while (iterator.hasNext()) {
            WSDLPort wSDLPort = (WSDLPort)iterator.next();
            WSDLPortType wSDLPortType = wSDLPort.getPortType();
            if (wSDLPortType == null) continue;
            ((List)arrayList).add(wSDLPortType);
        }
        return arrayList;
    }

    public void addPort(WSDLPort wSDLPort) {
        if (wSDLPort == null) {
            return;
        }
        if (this.ports == null) {
            this.ports = new LinkedMap();
        }
        this.ports.put(wSDLPort.getName(), wSDLPort);
        wSDLPort.setService(this);
    }

    public WSDLPort getPort(String string) {
        return this.ports == null ? null : (WSDLPort)this.ports.get(string);
    }

    public DataStructure getPorts() {
        return this.ports == null ? EmptyStructures.EMPTY_STRUCTURE : new ArrayList(this.ports.values());
    }

    public boolean containsPortsForBinding(QName qName) {
        if (this.ports == null) {
            return false;
        }
        Iterator iterator = this.ports.values().iterator();
        while (iterator.hasNext()) {
            WSDLPort wSDLPort = (WSDLPort)iterator.next();
            if (!qName.equals(wSDLPort.getBindingName())) continue;
            return true;
        }
        return false;
    }

    public WSDL getWsdl() {
        return this.wsdl;
    }

    void setWsdl(WSDL wSDL) {
        this.wsdl = wSDL;
    }
}

