/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.mxp1_serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xmlpull.v1.IllegalStateException;
import org.xmlpull.v1.XmlSerializer;

public class MXSerializer
implements XmlSerializer {
    protected static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    protected static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final boolean TRACE_SIZING = false;
    private static final boolean TRACE_ESCAPING = false;
    protected final String FEATURE_SERIALIZER_ATTVALUE_USE_APOSTROPHE = "http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe";
    protected final String PROPERTY_SERIALIZER_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    protected final String PROPERTY_SERIALIZER_LINE_SEPARATOR = "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator";
    protected static final String PROPERTY_LOCATION = "http://xmlpull.org/v1/doc/properties.html#location";
    protected boolean attributeUseApostrophe;
    protected String indentationString = null;
    protected String lineSeparator = "\n";
    protected String location;
    protected Writer out;
    protected int autoDeclaredPrefixes;
    protected int depth = 0;
    protected String[] elNamespace = new String[2];
    protected String[] elName = new String[this.elNamespace.length];
    protected String[] elPrefix = new String[this.elNamespace.length];
    protected int[] elNamespaceCount = new int[this.elNamespace.length];
    protected int namespaceEnd = 0;
    protected String[] namespacePrefix = new String[8];
    protected String[] namespaceUri = new String[this.namespacePrefix.length];
    protected boolean finished;
    protected boolean pastRoot;
    protected boolean setPrefixCalled;
    protected boolean startTagIncomplete;
    protected boolean doIndent;
    protected boolean seenTag;
    protected boolean seenBracket;
    protected boolean seenBracketBracket;
    private static final int BUF_LEN = Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 256;
    protected char[] buf = new char[BUF_LEN];
    protected static final String[] precomputedPrefixes = new String[32];
    protected int offsetNewLine;
    protected int indentationJump;
    protected char[] indentationBuf;
    protected int maxIndentLevel;
    protected boolean writeLineSepartor;
    protected boolean writeIndentation;

    protected void reset() {
        this.location = null;
        this.out = null;
        this.autoDeclaredPrefixes = 0;
        this.depth = 0;
        for (int i = 0; i < this.elNamespaceCount.length; ++i) {
            this.elName[i] = null;
            this.elPrefix[i] = null;
            this.elNamespace[i] = null;
            this.elNamespaceCount[i] = 2;
        }
        this.namespaceEnd = 0;
        this.namespacePrefix[this.namespaceEnd] = "xmlns";
        this.namespaceUri[this.namespaceEnd] = XMLNS_URI;
        ++this.namespaceEnd;
        this.namespacePrefix[this.namespaceEnd] = "xml";
        this.namespaceUri[this.namespaceEnd] = XML_URI;
        ++this.namespaceEnd;
        this.finished = false;
        this.pastRoot = false;
        this.setPrefixCalled = false;
        this.startTagIncomplete = false;
        this.seenTag = false;
        this.seenBracket = false;
        this.seenBracketBracket = false;
    }

    protected void ensureElementsCapacity() {
        int n = this.elName.length;
        int n2 = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
        boolean bl = n > 0;
        String[] stringArray = null;
        stringArray = new String[n2];
        if (bl) {
            System.arraycopy(this.elName, 0, stringArray, 0, n);
        }
        this.elName = stringArray;
        stringArray = new String[n2];
        if (bl) {
            System.arraycopy(this.elPrefix, 0, stringArray, 0, n);
        }
        this.elPrefix = stringArray;
        stringArray = new String[n2];
        if (bl) {
            System.arraycopy(this.elNamespace, 0, stringArray, 0, n);
        }
        this.elNamespace = stringArray;
        int[] nArray = new int[n2];
        if (bl) {
            System.arraycopy(this.elNamespaceCount, 0, nArray, 0, n);
        } else {
            nArray[0] = 0;
        }
        this.elNamespaceCount = nArray;
    }

    protected void ensureNamespacesCapacity() {
        int n = this.namespaceEnd > 7 ? 2 * this.namespaceEnd : 8;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        if (this.namespacePrefix != null) {
            System.arraycopy(this.namespacePrefix, 0, stringArray, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceUri, 0, stringArray2, 0, this.namespaceEnd);
        }
        this.namespacePrefix = stringArray;
        this.namespaceUri = stringArray2;
    }

    public void setFeature(String string, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        if (!"http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe".equals(string)) {
            throw new IllegalStateException("unsupported feature " + string);
        }
        this.attributeUseApostrophe = bl;
    }

    public boolean getFeature(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe".equals(string)) {
            return this.attributeUseApostrophe;
        }
        return false;
    }

    protected void rebuildIndentationBuf() {
        int n;
        if (!this.doIndent) {
            return;
        }
        int n2 = 0;
        this.offsetNewLine = 0;
        if (this.writeLineSepartor) {
            this.offsetNewLine = this.lineSeparator.length();
            n2 += this.offsetNewLine;
        }
        this.maxIndentLevel = 0;
        if (this.writeIndentation) {
            this.indentationJump = this.indentationString.length();
            this.maxIndentLevel = 65 / this.indentationJump;
            n2 += this.maxIndentLevel * this.indentationJump;
        }
        if (this.indentationBuf == null || this.indentationBuf.length < n2) {
            this.indentationBuf = new char[n2 + 8];
        }
        int n3 = 0;
        if (this.writeLineSepartor) {
            for (n = 0; n < this.lineSeparator.length(); ++n) {
                this.indentationBuf[n3++] = this.lineSeparator.charAt(n);
            }
        }
        if (this.writeIndentation) {
            for (n = 0; n < this.maxIndentLevel; ++n) {
                for (int i = 0; i < this.indentationString.length(); ++i) {
                    this.indentationBuf[n3++] = this.indentationString.charAt(i);
                }
            }
        }
    }

    protected void writeIndent() throws IOException {
        int n = this.writeLineSepartor ? 0 : this.offsetNewLine;
        int n2 = this.depth > this.maxIndentLevel ? this.maxIndentLevel : this.depth;
        this.out.write(this.indentationBuf, n, (n2 - 1) * this.indentationJump + this.offsetNewLine);
    }

    public void setProperty(String string, Object object) throws IllegalArgumentException, IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-indentation".equals(string)) {
            this.indentationString = (String)object;
        } else if ("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator".equals(string)) {
            this.lineSeparator = (String)object;
        } else if (PROPERTY_LOCATION.equals(string)) {
            this.location = (String)object;
        } else {
            throw new IllegalStateException("unsupported property " + string);
        }
        this.writeLineSepartor = this.lineSeparator != null && this.lineSeparator.length() > 0;
        this.writeIndentation = this.indentationString != null && this.indentationString.length() > 0;
        this.doIndent = this.indentationString != null && (this.writeLineSepartor || this.writeIndentation);
        this.rebuildIndentationBuf();
        this.seenTag = false;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-indentation".equals(string)) {
            return this.indentationString;
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator".equals(string)) {
            return this.lineSeparator;
        }
        if (PROPERTY_LOCATION.equals(string)) {
            return this.location;
        }
        return null;
    }

    private String getLocation() {
        return this.location != null ? " @" + this.location : "";
    }

    public Writer getWriter() {
        return this.out;
    }

    public void setOutput(Writer writer) {
        this.reset();
        this.out = writer;
    }

    public void setOutput(OutputStream outputStream, String string) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("output stream can not be null");
        }
        this.reset();
        this.out = string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream);
    }

    public void startDocument(String string, Boolean bl) throws IOException {
        if (this.attributeUseApostrophe) {
            this.out.write("<?xml version='1.0'");
        } else {
            this.out.write("<?xml version=\"1.0\"");
        }
        if (string != null) {
            this.out.write(" encoding=");
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            this.out.write(string);
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
        }
        if (bl != null) {
            this.out.write(" standalone=");
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            if (bl.booleanValue()) {
                this.out.write("yes");
            } else {
                this.out.write("no");
            }
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
        }
        this.out.write("?>");
    }

    public void endDocument() throws IOException {
        while (this.depth > 0) {
            this.endTag(this.elNamespace[this.depth], this.elName[this.depth]);
        }
        this.startTagIncomplete = true;
        this.pastRoot = true;
        this.finished = true;
        this.out.flush();
    }

    public void setPrefix(String string, String string2) throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        if (string == null) {
            string = "";
        }
        for (int i = this.elNamespaceCount[this.depth]; i < this.namespaceEnd; ++i) {
            if (string != this.namespacePrefix[i] && !string.equals(this.namespacePrefix[i])) continue;
            throw new IllegalStateException("duplicated prefix " + MXSerializer.printable(string) + this.getLocation());
        }
        if (string2 == null) {
            throw new IllegalArgumentException("namespace must be not null" + this.getLocation());
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = string;
        this.namespaceUri[this.namespaceEnd] = string2;
        ++this.namespaceEnd;
        this.setPrefixCalled = true;
    }

    protected String lookupOrDeclarePrefix(String string) {
        return this.getPrefix(string, true);
    }

    public String getPrefix(String string, boolean bl) {
        return this.getPrefix(string, bl, false);
    }

    protected String getPrefix(String string, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("namespace must be not null" + this.getLocation());
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("default namespace cannot have prefix" + this.getLocation());
        }
        for (int i = this.namespaceEnd - 1; i >= 0; --i) {
            if (!string.equals(this.namespaceUri[i])) continue;
            String string2 = this.namespacePrefix[i];
            if (bl2 && string2.length() == 0) continue;
            for (int j = this.namespaceEnd - 1; j > i; --j) {
                if (!string2.equals(this.namespacePrefix[j])) continue;
            }
            return string2;
        }
        if (!bl) {
            return null;
        }
        return this.generatePrefix(string);
    }

    private String generatePrefix(String string) {
        ++this.autoDeclaredPrefixes;
        String string2 = this.autoDeclaredPrefixes < precomputedPrefixes.length ? precomputedPrefixes[this.autoDeclaredPrefixes] : "n" + this.autoDeclaredPrefixes;
        for (int i = this.namespaceEnd - 1; i >= 0; --i) {
            if (!string2.equals(this.namespacePrefix[i])) continue;
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = string2;
        this.namespaceUri[this.namespaceEnd] = string;
        ++this.namespaceEnd;
        return string2;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getNamespace() {
        return this.elNamespace[this.depth];
    }

    public String getName() {
        return this.elName[this.depth];
    }

    public XmlSerializer startTag(String string, String string2) throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.seenBracketBracket = false;
        this.seenBracket = false;
        ++this.depth;
        if (this.doIndent && this.depth > 0 && this.seenTag) {
            this.writeIndent();
        }
        this.seenTag = true;
        this.setPrefixCalled = false;
        this.startTagIncomplete = true;
        if (this.depth + 1 >= this.elName.length) {
            this.ensureElementsCapacity();
        }
        this.elNamespace[this.depth] = string;
        this.elName[this.depth] = string2;
        if (this.out == null) {
            throw new IllegalStateException("setOutput() must called set before serialization can start");
        }
        this.out.write(60);
        if (string != null) {
            if (string.length() > 0) {
                String string3;
                String string4 = null;
                if (this.depth > 0 && this.namespaceEnd - this.elNamespaceCount[this.depth - 1] == 1 && ((string3 = this.namespaceUri[this.namespaceEnd - 1]) == string || string3.equals(string))) {
                    String string5 = this.namespacePrefix[this.namespaceEnd - 1];
                    for (int i = this.elNamespaceCount[this.depth - 1] - 1; i >= 2; --i) {
                        String string6 = this.namespacePrefix[i];
                        if (string6 != string5 && !string6.equals(string5)) continue;
                        String string7 = this.namespaceUri[i];
                        if (string7 != string3 && !string7.equals(string3)) break;
                        --this.namespaceEnd;
                        string4 = string5;
                        break;
                    }
                }
                if (string4 == null) {
                    string4 = this.lookupOrDeclarePrefix(string);
                }
                if (string4.length() > 0) {
                    this.elPrefix[this.depth] = string4;
                    this.out.write(string4);
                    this.out.write(58);
                } else {
                    this.elPrefix[this.depth] = "";
                }
            } else {
                for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                    if (this.namespacePrefix[i] != "" && !"".equals(this.namespacePrefix[i])) continue;
                    String string8 = this.namespaceUri[i];
                    if (string8 == null) {
                        this.setPrefix("", "");
                        break;
                    }
                    if (string8.length() <= 0) break;
                    throw new IllegalStateException("start tag can not be written in empty default namespace as default namespace is currently bound to '" + string8 + "'" + this.getLocation());
                }
                this.elPrefix[this.depth] = "";
            }
        } else {
            this.elPrefix[this.depth] = "";
        }
        this.out.write(string2);
        return this;
    }

    public XmlSerializer attribute(String string, String string2, String string3) throws IOException {
        if (!this.startTagIncomplete) {
            throw new IllegalArgumentException("startTag() must be called before attribute()" + this.getLocation());
        }
        this.out.write(32);
        if (string != null && string.length() > 0) {
            String string4 = this.getPrefix(string, false, true);
            if (string4 == null) {
                string4 = this.generatePrefix(string);
            }
            this.out.write(string4);
            this.out.write(58);
        }
        this.out.write(string2);
        this.out.write(61);
        this.out.write(this.attributeUseApostrophe ? 39 : 34);
        this.writeAttributeValue(string3, this.out);
        this.out.write(this.attributeUseApostrophe ? 39 : 34);
        return this;
    }

    protected void closeStartTag() throws IOException {
        if (this.finished) {
            throw new IllegalArgumentException("trying to write past already finished output" + this.getLocation());
        }
        if (this.seenBracket) {
            this.seenBracketBracket = false;
            this.seenBracket = false;
        }
        if (this.startTagIncomplete || this.setPrefixCalled) {
            if (this.setPrefixCalled) {
                throw new IllegalArgumentException("startTag() must be called immediately after setPrefix()" + this.getLocation());
            }
            if (!this.startTagIncomplete) {
                throw new IllegalArgumentException("trying to close start tag that is not opened" + this.getLocation());
            }
            this.writeNamespaceDeclarations();
            this.out.write(62);
            this.elNamespaceCount[this.depth] = this.namespaceEnd;
            this.startTagIncomplete = false;
        }
    }

    private void writeNamespaceDeclarations() throws IOException {
        for (int i = this.elNamespaceCount[this.depth - 1]; i < this.namespaceEnd; ++i) {
            if (this.doIndent && this.namespaceUri[i].length() > 40) {
                this.writeIndent();
                this.out.write(" ");
            }
            if (this.namespacePrefix[i] == "" || "".equals(this.namespacePrefix[i])) {
                this.out.write(" xmlns=");
            } else {
                this.out.write(" xmlns:");
                this.out.write(this.namespacePrefix[i]);
                this.out.write(61);
            }
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            this.writeAttributeValue(this.namespaceUri[i], this.out);
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
        }
    }

    public XmlSerializer endTag(String string, String string2) throws IOException {
        this.seenBracketBracket = false;
        this.seenBracket = false;
        if (string != this.elNamespace[this.depth] && !string.equals(this.elNamespace[this.depth])) {
            throw new IllegalArgumentException("expected namespace " + MXSerializer.printable(this.elNamespace[this.depth]) + " and not " + MXSerializer.printable(string) + this.getLocation());
        }
        if (string2 == null) {
            throw new IllegalArgumentException("end tag name can not be null" + this.getLocation());
        }
        String string3 = this.elName[this.depth];
        if (!string2.equals(string3)) {
            throw new IllegalArgumentException("expected element name " + MXSerializer.printable(this.elName[this.depth]) + " and not " + MXSerializer.printable(string2) + this.getLocation());
        }
        if (this.startTagIncomplete) {
            this.writeNamespaceDeclarations();
            this.out.write(" />");
            --this.depth;
        } else {
            if (this.doIndent && this.seenTag) {
                this.writeIndent();
            }
            this.out.write("</");
            String string4 = this.elPrefix[this.depth];
            if (string4.length() > 0) {
                this.out.write(string4);
                this.out.write(58);
            }
            this.out.write(string2);
            this.out.write(62);
            --this.depth;
        }
        this.namespaceEnd = this.elNamespaceCount[this.depth];
        this.startTagIncomplete = false;
        this.seenTag = true;
        return this;
    }

    public XmlSerializer text(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(string, this.out);
        return this;
    }

    public XmlSerializer text(char[] cArray, int n, int n2) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(cArray, n, n2, this.out);
        return this;
    }

    public void cdsect(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<![CDATA[");
        this.out.write(string);
        this.out.write("]]>");
    }

    public void entityRef(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write(38);
        this.out.write(string);
        this.out.write(59);
    }

    public void processingInstruction(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<?");
        this.out.write(string);
        this.out.write("?>");
    }

    public void comment(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<!--");
        this.out.write(string);
        this.out.write("-->");
    }

    public void docdecl(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<!DOCTYPE");
        this.out.write(string);
        this.out.write(">");
    }

    public void ignorableWhitespace(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty string is not allowed for ignorable whitespace" + this.getLocation());
        }
        this.out.write(string);
    }

    public void flush() throws IOException {
        if (!this.finished && this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.out.flush();
    }

    protected void writeAttributeValue(String string, Writer writer) throws IOException {
        char c = this.attributeUseApostrophe ? (char)'\'' : '\"';
        String string2 = this.attributeUseApostrophe ? "&apos;" : "&quot;";
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '&') {
                if (i > n) {
                    writer.write(string.substring(n, i));
                }
                writer.write("&amp;");
                n = i + 1;
            }
            if (c2 == '<') {
                if (i > n) {
                    writer.write(string.substring(n, i));
                }
                writer.write("&lt;");
                n = i + 1;
                continue;
            }
            if (c2 == c) {
                if (i > n) {
                    writer.write(string.substring(n, i));
                }
                writer.write(string2);
                n = i + 1;
                continue;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\r' || c2 == '\n' || c2 == '\t') {
                if (i > n) {
                    writer.write(string.substring(n, i));
                }
                writer.write("&#");
                writer.write(Integer.toString(c2));
                writer.write(59);
                n = i + 1;
                continue;
            }
            throw new IllegalStateException("character " + MXSerializer.printable(c2) + " (" + Integer.toString(c2) + ") is not allowed in output" + this.getLocation() + " (attr value=" + MXSerializer.printable(string) + ")");
        }
        if (n > 0) {
            writer.write(string.substring(n));
        } else {
            writer.write(string);
        }
    }

    protected void writeElementContent(String string, Writer writer) throws IOException {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ']') {
                if (this.seenBracket) {
                    this.seenBracketBracket = true;
                    continue;
                }
                this.seenBracket = true;
                continue;
            }
            if (c == '&') {
                if (i > n) {
                    writer.write(string.substring(n, i));
                }
                writer.write("&amp;");
                n = i + 1;
            } else if (c == '<') {
                if (i > n) {
                    writer.write(string.substring(n, i));
                }
                writer.write("&lt;");
                n = i + 1;
            } else if (this.seenBracketBracket && c == '>') {
                if (i > n) {
                    writer.write(string.substring(n, i));
                }
                writer.write("&gt;");
                n = i + 1;
            } else if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                throw new IllegalStateException("character " + Integer.toString(c) + " is not allowed in output" + this.getLocation() + " (text value=" + MXSerializer.printable(string) + ")");
            }
            if (!this.seenBracket) continue;
            this.seenBracket = false;
            this.seenBracketBracket = false;
        }
        if (n > 0) {
            writer.write(string.substring(n));
        } else {
            writer.write(string);
        }
    }

    protected void writeElementContent(char[] cArray, int n, int n2, Writer writer) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (c == ']') {
                if (this.seenBracket) {
                    this.seenBracketBracket = true;
                    continue;
                }
                this.seenBracket = true;
                continue;
            }
            if (c == '&') {
                if (i > n4) {
                    writer.write(cArray, n4, i - n4);
                }
                writer.write("&amp;");
                n4 = i + 1;
            } else if (c == '<') {
                if (i > n4) {
                    writer.write(cArray, n4, i - n4);
                }
                writer.write("&lt;");
                n4 = i + 1;
            } else if (this.seenBracketBracket && c == '>') {
                if (i > n4) {
                    writer.write(cArray, n4, i - n4);
                }
                writer.write("&gt;");
                n4 = i + 1;
            } else if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                throw new IllegalStateException("character " + MXSerializer.printable(c) + " (" + Integer.toString(c) + ") is not allowed in output" + this.getLocation());
            }
            if (!this.seenBracket) continue;
            this.seenBracket = false;
            this.seenBracketBracket = false;
        }
        if (n3 > n4) {
            writer.write(cArray, n4, n3 - n4);
        }
    }

    protected static final String printable(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        stringBuffer.append("'");
        for (int i = 0; i < string.length(); ++i) {
            MXSerializer.addPrintable(stringBuffer, string.charAt(i));
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    protected static final String printable(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        MXSerializer.addPrintable(stringBuffer, c);
        return stringBuffer.toString();
    }

    private static void addPrintable(StringBuffer stringBuffer, char c) {
        switch (c) {
            case '\b': {
                stringBuffer.append("\\b");
                break;
            }
            case '\t': {
                stringBuffer.append("\\t");
                break;
            }
            case '\n': {
                stringBuffer.append("\\n");
                break;
            }
            case '\f': {
                stringBuffer.append("\\f");
                break;
            }
            case '\r': {
                stringBuffer.append("\\r");
                break;
            }
            case '\"': {
                stringBuffer.append("\\\"");
                break;
            }
            case '\'': {
                stringBuffer.append("\\'");
                break;
            }
            case '\\': {
                stringBuffer.append("\\\\");
                break;
            }
            default: {
                if (c < ' ' || c > '~') {
                    String string = "0000" + Integer.toString(c, 16);
                    stringBuffer.append("\\u" + string.substring(string.length() - 4, string.length()));
                    break;
                }
                stringBuffer.append(c);
            }
        }
    }

    static {
        for (int i = 0; i < precomputedPrefixes.length; ++i) {
            MXSerializer.precomputedPrefixes[i] = "n" + i;
        }
    }
}

