/*
 * Decompiled with CFR 0.152.
 */
package edu.uga.cs.lsdis.sawsdl.impl.extensions.schema;

import edu.uga.cs.lsdis.sawsdl.Definition;
import edu.uga.cs.lsdis.sawsdl.ModelReference;
import edu.uga.cs.lsdis.sawsdl.WSDLSException;
import edu.uga.cs.lsdis.sawsdl.extensions.schema.Schema;
import edu.uga.cs.lsdis.sawsdl.impl.Constants;
import edu.uga.cs.lsdis.sawsdl.impl.util.ModelRefUtil;
import edu.uga.cs.lsdis.sawsdl.impl.util.SchemaUtils;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaImpl
extends com.ibm.wsdl.extensions.schema.SchemaImpl
implements Schema {
    @Override
    public ModelReference getModelReference(Element startElement, String path, Definition def) throws WSDLSException, URISyntaxException {
        Set<ModelReference> mrefs = this.getModelReferences(startElement, path, def);
        return mrefs.toArray(new ModelReference[mrefs.size()])[0];
    }

    @Override
    public void addModelReference(Element startElement, String path, ModelReference modelReference) throws WSDLSException {
        Element el = this.getXSDElement(startElement, path);
        if (el != null) {
            if (modelReference != null) {
                String value;
                String strModelReference = modelReference.toString();
                Attr attr = el.getAttributeNodeNS("http://www.w3.org/2007/01/sawsdl#", "modelReference");
                if (attr == null) {
                    attr = el.getOwnerDocument().createAttributeNS("http://www.w3.org/2007/01/sawsdl#", "modelReference");
                    attr.setPrefix("sawsdl");
                    el.setAttributeNodeNS(attr);
                }
                value = (value = attr.getValue()) != null ? value + " " + strModelReference : strModelReference;
                attr.setValue(value);
                modelReference.setParent(el);
            } else {
                el.removeAttributeNS("http://www.w3.org/2007/01/sawsdl#", "modelReference");
            }
        } else {
            throw new WSDLSException("", "Xpath did not result in an element");
        }
    }

    protected Element getXSDElement(Element startElement, String path) throws WSDLSException {
        return SchemaUtils.findXSDElement(startElement, path, this);
    }

    @Override
    public Set<ModelReference> getModelReferences(Element startElement, String path, Definition def) throws WSDLSException, URISyntaxException {
        Element el = this.getXSDElement(startElement, path);
        if (el == null) {
            return null;
        }
        String attrModelReferenceString = el.getAttributeNS("http://www.w3.org/2007/01/sawsdl#", "modelReference").trim();
        Set<ModelReference> propogateModelRefs = null;
        if ((Constants.Q_SCEHMA_ELEMENT.getLocalPart().equals(el.getLocalName()) || Constants.Q_SCEHMA_ATTRIBUTE.getLocalPart().equals(el.getLocalName())) && Constants.Q_SCEHMA_ELEMENT.getNamespaceURI().equals(el.getNamespaceURI())) {
            propogateModelRefs = this.getPropogatedReferences(el, def);
        }
        if (attrModelReferenceString.equals("")) {
            return propogateModelRefs;
        }
        Set<ModelReference> mrefs = ModelRefUtil.parseModelReference(attrModelReferenceString, def, (Object)el);
        if (mrefs.size() == 0) {
            return propogateModelRefs;
        }
        if (propogateModelRefs != null) {
            mrefs.addAll(propogateModelRefs);
        }
        return mrefs;
    }

    private Set<ModelReference> getPropogatedReferences(Element el, Definition def) throws WSDLSException, URISyntaxException {
        javax.wsdl.extensions.schema.Schema schema = this.getRelevantSchema(el, def);
        if (schema == null) {
            return null;
        }
        String typeAttributeString = el.getAttribute("type");
        String typeName = null;
        typeName = typeAttributeString.indexOf(58) > 0 ? typeAttributeString.split(":")[1] : typeAttributeString;
        Set<ModelReference> modelRefs = this.getModelReferences(schema.getElement(), "//xsd:simpleType[@name=\"" + typeName + "\"]", def);
        if (modelRefs == null) {
            modelRefs = this.getModelReferences(schema.getElement(), "//xsd:complexType[@name=\"" + typeName + "\"]", def);
        }
        return modelRefs;
    }

    private Set<String> getPropogatedMapping(Element el, Definition def, String type) throws WSDLSException, URISyntaxException {
        javax.wsdl.extensions.schema.Schema schema = this.getRelevantSchema(el, def);
        if (schema == null) {
            return null;
        }
        String typeAttributeString = el.getAttribute("type").trim();
        String typeName = null;
        typeName = typeAttributeString.indexOf(58) > 0 ? typeAttributeString.split(":")[1] : typeAttributeString;
        Set<String> modelRefs = this.getAttValueAsSet(schema.getElement(), "//xsd:simpleType[@name=\"" + typeName + "\"]", type, def);
        if (modelRefs == null) {
            modelRefs = this.getAttValueAsSet(schema.getElement(), "//xsd:complexType[@name=\"" + typeName + "\"]", type, def);
        }
        return modelRefs;
    }

    private javax.wsdl.extensions.schema.Schema getRelevantSchema(Element el, Definition def) throws WSDLSException, URISyntaxException {
        Object aSchemaList;
        String tns;
        String typeAttributeString = el.getAttribute("type").trim();
        if ("".equals(typeAttributeString)) {
            return null;
        }
        String typeSchemaNamespace = null;
        if (typeAttributeString.indexOf(58) > 0) {
            String nsprefix = typeAttributeString.split(":")[0];
            typeSchemaNamespace = (String)def.getNamespaces().get(nsprefix);
        } else {
            typeSchemaNamespace = el.getOwnerDocument().lookupNamespaceURI(null);
        }
        if (typeSchemaNamespace == null || "".equals(typeSchemaNamespace)) {
            throw new WSDLSException("", "type namespace prefix did not match any known schema namespace");
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(typeSchemaNamespace)) {
            return null;
        }
        List schemaList = def.getTypes().getExtensibilityElements();
        javax.wsdl.extensions.schema.Schema schema = null;
        Iterator i$ = schemaList.iterator();
        while (i$.hasNext() && !(tns = (schema = (javax.wsdl.extensions.schema.Schema)(aSchemaList = i$.next())).getElement().getAttribute("targetNamespace")).equals(typeSchemaNamespace)) {
        }
        if (schema == null) {
            throw new WSDLSException("", "could not find any schema object for the namespace" + typeSchemaNamespace);
        }
        return schema;
    }

    @Override
    public void setModelReferences(Element startElement, String path, Set<ModelReference> refs) throws WSDLSException {
        for (ModelReference ref : refs) {
            this.addModelReference(startElement, path, ref);
        }
    }

    @Override
    public void addLiftingMapping(Element startElement, String path, String liftingMapping, Definition def) throws WSDLSException, URISyntaxException {
        Set<String> liftingMappings = this.getLiftingMappings(startElement, path, def);
        if (liftingMappings != null && !liftingMappings.isEmpty()) {
            liftingMappings.add(liftingMapping);
        } else {
            HashSet<String> tempSet = new HashSet<String>();
            tempSet.add(liftingMapping);
            this.setLiftingMappings(startElement, path, tempSet);
        }
    }

    @Override
    public Set<String> getLiftingMappings(Element startElement, String path, Definition def) throws WSDLSException, URISyntaxException {
        return this.getAttValueAsSet(startElement, path, "liftingSchemaMapping", def);
    }

    @Override
    public void setLiftingMappings(Element startElement, String path, Set<String> mappings) throws WSDLSException {
        this.setAttValueAsSet(startElement, path, "liftingSchemaMapping", mappings);
    }

    @Override
    public void addLoweringMapping(Element startElement, String path, String loweringMapping, Definition def) throws WSDLSException, URISyntaxException {
        Set<String> loweringMappings = this.getLoweringMappings(startElement, path, def);
        if (loweringMappings != null && !loweringMappings.isEmpty()) {
            loweringMappings.add(loweringMapping);
        } else {
            HashSet<String> tempSet = new HashSet<String>();
            tempSet.add(loweringMapping);
            this.setLoweringMappings(startElement, path, tempSet);
        }
    }

    @Override
    public Set<String> getLoweringMappings(Element startElement, String path, Definition def) throws WSDLSException, URISyntaxException {
        return this.getAttValueAsSet(startElement, path, "loweringSchemaMapping", def);
    }

    @Override
    public void setLoweringMappings(Element startElement, String path, Set<String> mappings) throws WSDLSException {
        this.setAttValueAsSet(startElement, path, "loweringSchemaMapping", mappings);
    }

    protected Set<String> getAttValueAsSet(Element startElement, String path, String attNameToGet, Definition def) throws WSDLSException, URISyntaxException {
        Element el = this.getXSDElement(startElement, path);
        if (el == null) {
            return null;
        }
        String mappingString = el.getAttributeNS("http://www.w3.org/2007/01/sawsdl#", attNameToGet).trim();
        if (!el.hasAttributeNS("http://www.w3.org/2007/01/sawsdl#", attNameToGet)) {
            Set<String> propogateModelRefs = null;
            if (Constants.Q_SCEHMA_ELEMENT.getLocalPart().equals(el.getLocalName()) && Constants.Q_SCEHMA_ELEMENT.getNamespaceURI().equals(el.getNamespaceURI())) {
                propogateModelRefs = this.getPropogatedMapping(el, def, attNameToGet);
            }
            return propogateModelRefs;
        }
        if ("".equals(mappingString)) {
            return null;
        }
        String[] mappings = ModelRefUtil.splitString(mappingString);
        if (mappings.length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(mappings));
    }

    protected boolean setAttValueAsSet(Element startElement, String path, String attNameToSet, Set<String> values) throws WSDLSException {
        Element el = this.getXSDElement(startElement, path);
        if (el == null) {
            return false;
        }
        String valueString = "";
        for (String s : values) {
            valueString = valueString + " " + s;
        }
        el.setAttributeNS("http://www.w3.org/2007/01/sawsdl#", attNameToSet, valueString);
        return true;
    }
}

