/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes;

import com.jcraft.jsch.JSchException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jclouds.compute.RunNodesException;
import org.ow2.choreos.chef.KnifeException;
import org.ow2.choreos.deployment.nodes.chef.ConfigToChef;
import org.ow2.choreos.deployment.nodes.cloudprovider.CloudProvider;
import org.ow2.choreos.deployment.nodes.cm.NodeBootstrapper;
import org.ow2.choreos.deployment.nodes.cm.NodeNotBootstrappedException;
import org.ow2.choreos.deployment.nodes.cm.NodeUpgrader;
import org.ow2.choreos.deployment.nodes.cm.RecipeApplier;
import org.ow2.choreos.deployment.nodes.selector.NodeSelector;
import org.ow2.choreos.deployment.nodes.selector.NodeSelectorFactory;
import org.ow2.choreos.nodes.ConfigNotAppliedException;
import org.ow2.choreos.nodes.NodeNotAccessibleException;
import org.ow2.choreos.nodes.NodeNotCreatedException;
import org.ow2.choreos.nodes.NodeNotDestroyed;
import org.ow2.choreos.nodes.NodeNotFoundException;
import org.ow2.choreos.nodes.NodeNotUpgradedException;
import org.ow2.choreos.nodes.NodePoolManager;
import org.ow2.choreos.nodes.datamodel.Config;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.services.datamodel.ResourceImpact;

public class NPMImpl
implements NodePoolManager {
    private Logger logger = Logger.getLogger(NPMImpl.class);
    private CloudProvider cloudProvider;

    public NPMImpl(CloudProvider provider) {
        this.cloudProvider = provider;
    }

    public Node createNode(Node node, ResourceImpact resourceImpact) throws NodeNotCreatedException {
        return this.createNode(node, resourceImpact, true);
    }

    private Node createNode(Node node, ResourceImpact resourceImpact, boolean retry) throws NodeNotCreatedException {
        try {
            this.cloudProvider.createNode(node, resourceImpact);
        }
        catch (RunNodesException e) {
            if (retry) {
                this.logger.warn((Object)"Could not create VM. Going to try again!");
                this.createNode(node, resourceImpact, false);
            }
            throw new NodeNotCreatedException(node.getId(), "Could not create VM");
        }
        try {
            NodeBootstrapper bootstrapper = new NodeBootstrapper(node);
            bootstrapper.bootstrapNode();
        }
        catch (KnifeException e) {
            throw new NodeNotCreatedException(node.getId(), "Could not initialize node " + node);
        }
        catch (NodeNotBootstrappedException e) {
            throw new NodeNotCreatedException(node.getId(), "Could not initialize node " + node);
        }
        catch (NodeNotAccessibleException e) {
            if (retry) {
                this.logger.warn((Object)("Could not connect to the node " + node + ". We will forget this node and try a new one."));
                this.createNode(node, resourceImpact, false);
            }
            throw new NodeNotCreatedException(node.getId(), "Could not connect to the node " + node);
        }
        return node;
    }

    public List<Node> getNodes() {
        return this.cloudProvider.getNodes();
    }

    public Node getNode(String nodeId) throws NodeNotFoundException {
        return this.cloudProvider.getNode(nodeId);
    }

    public List<Node> applyConfig(Config config) throws ConfigNotAppliedException {
        NodeSelector selector = NodeSelectorFactory.getInstance(this.cloudProvider);
        List<Node> nodes = selector.selectNodes(config);
        if (nodes == null) {
            throw new ConfigNotAppliedException(config.getName());
        }
        String cookbook = ConfigToChef.getCookbookNameFromConfigName(config.getName());
        String recipe = ConfigToChef.getRecipeNameFromConfigName(config.getName());
        for (Node node : nodes) {
            this.applyConfig(config, node, cookbook, recipe);
        }
        return nodes;
    }

    private void applyConfig(Config config, Node node, String cookbook, String recipe) throws ConfigNotAppliedException {
        int TRIALS = 3;
        int SLEEP_TIME = 1000;
        int step = 0;
        boolean ok = false;
        while (!ok) {
            try {
                RecipeApplier recipeApplyer = new RecipeApplier();
                recipeApplyer.applyRecipe(node, cookbook, recipe);
                ok = true;
            }
            catch (ConfigNotAppliedException e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    this.logger.error((Object)"Exception at sleeping!", (Throwable)e1);
                }
                if (++step <= 3) continue;
                throw new ConfigNotAppliedException(config.getName());
            }
        }
    }

    public void upgradeNode(String nodeId) throws NodeNotUpgradedException, NodeNotFoundException {
        Node node = this.getNode(nodeId);
        NodeUpgrader upgrader = new NodeUpgrader();
        try {
            upgrader.upgradeNodeConfiguration(node);
        }
        catch (JSchException e) {
            throw new NodeNotUpgradedException(node.getId(), "Could not connect through ssh");
        }
    }

    public void destroyNode(String nodeId) throws NodeNotDestroyed, NodeNotFoundException {
        this.cloudProvider.destroyNode(nodeId);
    }

    public void destroyNodes() throws NodeNotDestroyed {
        ArrayList<Thread> trds = new ArrayList<Thread>();
        ArrayList<NodeDestroyer> destroyers = new ArrayList<NodeDestroyer>();
        for (Node node : this.getNodes()) {
            NodeDestroyer destroyer = new NodeDestroyer(node);
            Thread trd = new Thread(destroyer);
            destroyers.add(destroyer);
            trds.add(trd);
            trd.start();
        }
        this.waitThreads(trds);
        for (NodeDestroyer destroyer : destroyers) {
            if (destroyer.ok) continue;
            throw new NodeNotDestroyed(destroyer.node.getId());
        }
    }

    private void waitThreads(List<Thread> trds) {
        for (Thread t : trds) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Error while waiting thread", (Throwable)e);
            }
        }
    }

    private class NodeDestroyer
    implements Runnable {
        Node node;
        boolean ok;

        public NodeDestroyer(Node node) {
            this.node = node;
        }

        @Override
        public void run() {
            try {
                NPMImpl.this.destroyNode(this.node.getId());
            }
            catch (NodeNotDestroyed e) {
                this.ok = false;
                NPMImpl.this.logger.error((Object)"Node not destroyed", (Throwable)e);
            }
            catch (NodeNotFoundException e) {
                this.ok = false;
                NPMImpl.this.logger.error((Object)"Impossible!", (Throwable)e);
            }
            NPMImpl.this.logger.info((Object)("Node " + this.node.getId() + " destroyed"));
            this.ok = true;
        }
    }
}

