/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.cloudprovider;

import org.ow2.choreos.deployment.nodes.cloudprovider.AWSCloudProvider;
import org.ow2.choreos.deployment.nodes.cloudprovider.CloudProvider;
import org.ow2.choreos.deployment.nodes.cloudprovider.FixedCloudProvider;
import org.ow2.choreos.deployment.nodes.cloudprovider.OpenStackKeystoneCloudProvider;

public class CloudProviderFactory {
    public static CloudProvider getInstance(String cloudProviderType) {
        CloudProviderType type;
        try {
            type = CloudProviderType.valueOf(cloudProviderType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Invalid CLOUD_PROVIDER in properties file: " + cloudProviderType);
        }
        return CloudProviderFactory.getInstance(type);
    }

    public static CloudProvider getInstance(CloudProviderType type) {
        switch (type) {
            case AWS: {
                return new AWSCloudProvider();
            }
            case FIXED: {
                return new FixedCloudProvider();
            }
            case OPEN_STACK: {
                return new OpenStackKeystoneCloudProvider();
            }
        }
        throw new IllegalArgumentException("Invalid cloud provider type");
    }

    public static enum CloudProviderType {
        FIXED,
        AWS,
        OPEN_STACK;

    }
}

