/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.cm;

import com.jcraft.jsch.JSchException;
import java.util.List;
import org.apache.log4j.Logger;
import org.ow2.choreos.chef.ChefNodeNameRetriever;
import org.ow2.choreos.chef.KnifeException;
import org.ow2.choreos.chef.impl.KnifeImpl;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.cm.BootstrapChecker;
import org.ow2.choreos.deployment.nodes.cm.NodeBootstrapper;
import org.ow2.choreos.deployment.nodes.cm.NodeNotBootstrappedException;
import org.ow2.choreos.deployment.nodes.cm.NodeNotOKException;
import org.ow2.choreos.nodes.NodeNotAccessibleException;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.utils.SshCommandFailed;

public class NodeChecker {
    private Logger logger = Logger.getLogger(NodeChecker.class);
    private static final String CHEF_REPO = Configuration.get("CHEF_REPO");
    private static final String CHEF_CONFIG_FILE = Configuration.get("CHEF_CONFIG_FILE");

    public void checkAndPrepareNode(Node node) throws NodeNotOKException {
        if (node.getChefName() == null || node.getChefName().isEmpty()) {
            BootstrapChecker checker = new BootstrapChecker();
            if (!checker.isBootstrapped(node)) {
                this.logger.debug((Object)("Node " + node.getIp() + " not bootstrapped yet. Going to bootstrap it."));
                NodeBootstrapper bootstrapper = new NodeBootstrapper(node);
                try {
                    bootstrapper.bootstrapNode();
                }
                catch (NodeNotAccessibleException e) {
                    throw new NodeNotOKException();
                }
                catch (KnifeException e) {
                    throw new NodeNotOKException();
                }
                catch (NodeNotBootstrappedException e) {
                    throw new NodeNotOKException();
                }
            }
            this.logger.debug((Object)("Node " + node.getIp() + " bootstrapped but without chef name. Going to retrieve chef name"));
            ChefNodeNameRetriever retriever = new ChefNodeNameRetriever();
            String chefName = "";
            try {
                chefName = retriever.getChefNodeName(node.getIp(), node.getUser(), node.getPrivateKeyFile());
            }
            catch (JSchException e) {
                throw new NodeNotOKException();
            }
            catch (SshCommandFailed e) {
                throw new NodeNotOKException();
            }
            this.logger.debug((Object)("Retrieved chef name for  " + node.getIp() + ": " + chefName));
            node.setChefName(chefName);
        }
        if (!this.checkNodeOnNodesList(node)) {
            throw new NodeNotOKException();
        }
    }

    public boolean checkNodeOnNodesList(Node node) {
        List nodes;
        KnifeImpl knife = new KnifeImpl(CHEF_CONFIG_FILE, CHEF_REPO);
        try {
            nodes = knife.node().list();
        }
        catch (KnifeException e) {
            return false;
        }
        if (nodes == null) {
            return false;
        }
        boolean ok = nodes.contains(node.getChefName());
        if (ok) {
            return true;
        }
        this.logger.debug((Object)("Chef does not know node " + node.getChefName()));
        return false;
    }
}

