/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.nodes.cm;

import org.apache.log4j.Logger;
import org.ow2.choreos.chef.ChefNode;
import org.ow2.choreos.chef.Knife;
import org.ow2.choreos.chef.KnifeException;
import org.ow2.choreos.chef.impl.KnifeImpl;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.nodes.cm.NodeChecker;
import org.ow2.choreos.deployment.nodes.cm.NodeNotOKException;
import org.ow2.choreos.nodes.ConfigNotAppliedException;
import org.ow2.choreos.nodes.datamodel.Node;

public class RecipeApplier {
    private Logger logger = Logger.getLogger(RecipeApplier.class);
    private static final String CHEF_REPO = Configuration.get("CHEF_REPO");
    private static final String CHEF_CONFIG_FILE = Configuration.get("CHEF_CONFIG_FILE");

    public void applyRecipe(Node node, String cookbook) throws ConfigNotAppliedException {
        this.applyRecipe(node, cookbook, "default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyRecipe(Node node, String cookbook, String recipe) throws ConfigNotAppliedException {
        String configName = cookbook + "::" + recipe;
        NodeChecker checker = new NodeChecker();
        try {
            checker.checkAndPrepareNode(node);
        }
        catch (NodeNotOKException e) {
            throw new ConfigNotAppliedException(configName, node.getId());
        }
        KnifeImpl knife = new KnifeImpl(CHEF_CONFIG_FILE, CHEF_REPO);
        this.logger.debug((Object)("aaplying " + configName + " to node " + node.getChefName()));
        Class<RecipeApplier> clazz = RecipeApplier.class;
        synchronized (RecipeApplier.class) {
            try {
                knife.node().runListAdd(node.getChefName(), cookbook, recipe);
            }
            catch (KnifeException e) {
                throw new ConfigNotAppliedException(cookbook + "::" + recipe, node.getId());
            }
            boolean ok = this.verifyRecipeInRunList((Knife)knife, node.getChefName(), cookbook, recipe);
            if (!ok) {
                throw new ConfigNotAppliedException(cookbook + "::" + recipe, node.getId());
            }
            return;
        }
    }

    private boolean verifyRecipeInRunList(Knife knife, String chefName, String cookbook, String recipe) {
        try {
            ChefNode chefNode = knife.node().show(chefName);
            return chefNode.hasRecipeOnRunlist(cookbook + "::" + recipe);
        }
        catch (KnifeException e) {
            return false;
        }
    }
}

