/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.deployment.services.recipe;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.ow2.choreos.deployment.Configuration;
import org.ow2.choreos.deployment.services.recipe.RecipeBuilder;
import org.ow2.choreos.services.datamodel.DeployableServiceSpec;
import org.ow2.choreos.services.datamodel.Recipe;

public abstract class BaseRecipeBuilder
implements RecipeBuilder {
    private Logger logger = Logger.getLogger(BaseRecipeBuilder.class);
    private static final File DEST_DIR = new File("src/main/resources/chef/recipes");
    private final String templateDir;
    private final String recipeName;
    private String recipeFile;

    public BaseRecipeBuilder(String templateDir, String recipeName) {
        this.templateDir = templateDir;
        this.recipeName = recipeName;
    }

    @Override
    public Recipe createRecipe(DeployableServiceSpec serviceSpec) {
        Recipe recipe = new Recipe();
        try {
            recipe.setName(this.recipeName);
            recipe.setCookbookName("service" + serviceSpec.getUUID());
            this.recipeFile = this.recipeName + ".rb";
            File targetFolder = this.getTargetFolder(serviceSpec);
            recipe.setCookbookFolder(targetFolder.getAbsolutePath());
            boolean cache = Boolean.parseBoolean(Configuration.get("RECIPES_CACHE"));
            if (targetFolder.exists() && cache) {
                this.logger.warn((Object)("Recipe " + this.recipeFile + " already exists and recipe cache is True. NOT going to overwriting it"));
            } else {
                this.copyTemplate(serviceSpec);
                this.changeMetadataRb(serviceSpec);
                this.changeAttributesDefaultRb(serviceSpec);
                this.changeServerRecipe(serviceSpec);
            }
            return recipe;
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not create recipe", (Throwable)e);
            return null;
        }
    }

    public abstract String replace(String var1, DeployableServiceSpec var2);

    void changeMetadataRb(DeployableServiceSpec serviceSpec) throws IOException {
        this.changeFileContents(serviceSpec, "/service" + serviceSpec.getUUID() + "/metadata.rb");
    }

    private void changeServerRecipe(DeployableServiceSpec serviceSpec) throws IOException {
        this.changeFileContents(serviceSpec, "/service" + serviceSpec.getUUID() + "/recipes/" + this.recipeFile);
    }

    void changeAttributesDefaultRb(DeployableServiceSpec serviceSpec) throws IOException {
        this.changeFileContents(serviceSpec, "/service" + serviceSpec.getUUID() + "/attributes/default.rb");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeFileContents(DeployableServiceSpec serviceSpec, String fileLocation) throws IOException {
        File file = new File(DEST_DIR + fileLocation);
        String fileData = null;
        Class<BaseRecipeBuilder> clazz = BaseRecipeBuilder.class;
        synchronized (BaseRecipeBuilder.class) {
            fileData = FileUtils.readFileToString((File)file);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            fileData = this.replace(fileData, serviceSpec);
            clazz = BaseRecipeBuilder.class;
            synchronized (BaseRecipeBuilder.class) {
                FileUtils.deleteQuietly((File)file);
                FileUtils.writeStringToFile((File)file, (String)fileData);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }
    }

    private File getTargetFolder(DeployableServiceSpec serviceSpec) {
        String destPath = DEST_DIR.getAbsolutePath() + "/service" + serviceSpec.getUUID();
        File destFolder = new File(destPath);
        return destFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String copyTemplate(DeployableServiceSpec serviceSpec) throws IOException {
        File srcFolder = new File(this.templateDir);
        String destPath = DEST_DIR.getAbsolutePath() + "/service" + serviceSpec.getUUID();
        File destFolder = new File(destPath);
        Class<BaseRecipeBuilder> clazz = BaseRecipeBuilder.class;
        synchronized (BaseRecipeBuilder.class) {
            block5: {
                try {
                    FileUtils.copyDirectory((File)srcFolder, (File)destFolder);
                }
                catch (IOException e) {
                    this.logger.warn((Object)"IOException when copying recipe template; it should not happen");
                    File dest = new File(destPath);
                    if (dest.exists()) break block5;
                    throw e;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return destFolder.getAbsolutePath();
        }
    }
}

