#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_07933e07-f3af-478e-8900-52720a33224c_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-07933e07-f3af-478e-8900-52720a33224c.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-07933e07-f3af-478e-8900-52720a33224c.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['07933e07-f3af-478e-8900-52720a33224c']['InstallationDir']}/service-07933e07-f3af-478e-8900-52720a33224c.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-07933e07-f3af-478e-8900-52720a33224c.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['07933e07-f3af-478e-8900-52720a33224c']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['07933e07-f3af-478e-8900-52720a33224c']['InstallationDir']}/service-07933e07-f3af-478e-8900-52720a33224c.jar" do
  		source "#{node['CHOReOSData']['serviceData']['07933e07-f3af-478e-8900-52720a33224c']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_07933e07-f3af-478e-8900-52720a33224c_jar]"
		notifies :start, "service[service_07933e07-f3af-478e-8900-52720a33224c_jar]"
	end
end

if node['CHOReOSData']['serviceData']['07933e07-f3af-478e-8900-52720a33224c']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['07933e07-f3af-478e-8900-52720a33224c']['InstallationDir']}/service-07933e07-f3af-478e-8900-52720a33224c.jar" do
		notifies :stop, "service[service_07933e07-f3af-478e-8900-52720a33224c_jar]", :immediately
		#notifies :disable, "service[service_07933e07-f3af-478e-8900-52720a33224c_jar]", :immediately
		action :delete
	end
end