#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_1460a0e8-e2d5-48f8-aa4d-789e77676be0_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service1460a0e8-e2d5-48f8-aa4d-789e77676be0Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['1460a0e8-e2d5-48f8-aa4d-789e77676be0']['installationDir']}/service1460a0e8-e2d5-48f8-aa4d-789e77676be0Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service1460a0e8-e2d5-48f8-aa4d-789e77676be0Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['1460a0e8-e2d5-48f8-aa4d-789e77676be0']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['1460a0e8-e2d5-48f8-aa4d-789e77676be0']['InstallationDir']}/service1460a0e8-e2d5-48f8-aa4d-789e77676be0Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['1460a0e8-e2d5-48f8-aa4d-789e77676be0']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_1460a0e8-e2d5-48f8-aa4d-789e77676be0_jar]"
		notifies :start, "service[service_1460a0e8-e2d5-48f8-aa4d-789e77676be0_jar]"
	end
end

if node['CHOReOSData']['serviceData']['1460a0e8-e2d5-48f8-aa4d-789e77676be0']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['1460a0e8-e2d5-48f8-aa4d-789e77676be0']['InstallationDir']}/service1460a0e8-e2d5-48f8-aa4d-789e77676be0Deploy.jar" do
		notifies :stop, "service[service_1460a0e8-e2d5-48f8-aa4d-789e77676be0_jar]", :immediately
		#notifies :disable, "service[service_1460a0e8-e2d5-48f8-aa4d-789e77676be0_jar]", :immediately
		action :delete
	end
end