#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_27ca7154-d6e6-4364-8838-48681fef38ba_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-27ca7154-d6e6-4364-8838-48681fef38ba.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-27ca7154-d6e6-4364-8838-48681fef38ba.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['27ca7154-d6e6-4364-8838-48681fef38ba']['InstallationDir']}/service-27ca7154-d6e6-4364-8838-48681fef38ba.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-27ca7154-d6e6-4364-8838-48681fef38ba.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['27ca7154-d6e6-4364-8838-48681fef38ba']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['27ca7154-d6e6-4364-8838-48681fef38ba']['InstallationDir']}/service-27ca7154-d6e6-4364-8838-48681fef38ba.jar" do
  		source "#{node['CHOReOSData']['serviceData']['27ca7154-d6e6-4364-8838-48681fef38ba']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_27ca7154-d6e6-4364-8838-48681fef38ba_jar]"
		notifies :start, "service[service_27ca7154-d6e6-4364-8838-48681fef38ba_jar]"
	end
end

if node['CHOReOSData']['serviceData']['27ca7154-d6e6-4364-8838-48681fef38ba']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['27ca7154-d6e6-4364-8838-48681fef38ba']['InstallationDir']}/service-27ca7154-d6e6-4364-8838-48681fef38ba.jar" do
		notifies :stop, "service[service_27ca7154-d6e6-4364-8838-48681fef38ba_jar]", :immediately
		#notifies :disable, "service[service_27ca7154-d6e6-4364-8838-48681fef38ba_jar]", :immediately
		action :delete
	end
end