#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_2983e9a1-c631-44b6-a4d9-5866c4a86cdd_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service2983e9a1-c631-44b6-a4d9-5866c4a86cddDeploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['2983e9a1-c631-44b6-a4d9-5866c4a86cdd']['installationDir']}/service2983e9a1-c631-44b6-a4d9-5866c4a86cddDeploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service2983e9a1-c631-44b6-a4d9-5866c4a86cddDeploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['2983e9a1-c631-44b6-a4d9-5866c4a86cdd']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['2983e9a1-c631-44b6-a4d9-5866c4a86cdd']['InstallationDir']}/service2983e9a1-c631-44b6-a4d9-5866c4a86cddDeploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['2983e9a1-c631-44b6-a4d9-5866c4a86cdd']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_2983e9a1-c631-44b6-a4d9-5866c4a86cdd_jar]"
		notifies :start, "service[service_2983e9a1-c631-44b6-a4d9-5866c4a86cdd_jar]"
	end
end

if node['CHOReOSData']['serviceData']['2983e9a1-c631-44b6-a4d9-5866c4a86cdd']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['2983e9a1-c631-44b6-a4d9-5866c4a86cdd']['InstallationDir']}/service2983e9a1-c631-44b6-a4d9-5866c4a86cddDeploy.jar" do
		notifies :stop, "service[service_2983e9a1-c631-44b6-a4d9-5866c4a86cdd_jar]", :immediately
		#notifies :disable, "service[service_2983e9a1-c631-44b6-a4d9-5866c4a86cdd_jar]", :immediately
		action :delete
	end
end