#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_358ec9ee-c2a0-48d2-9ad2-944bb15a8a87_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service358ec9ee-c2a0-48d2-9ad2-944bb15a8a87Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['358ec9ee-c2a0-48d2-9ad2-944bb15a8a87']['installationDir']}/service358ec9ee-c2a0-48d2-9ad2-944bb15a8a87Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service358ec9ee-c2a0-48d2-9ad2-944bb15a8a87Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['358ec9ee-c2a0-48d2-9ad2-944bb15a8a87']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['358ec9ee-c2a0-48d2-9ad2-944bb15a8a87']['InstallationDir']}/service358ec9ee-c2a0-48d2-9ad2-944bb15a8a87Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['358ec9ee-c2a0-48d2-9ad2-944bb15a8a87']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_358ec9ee-c2a0-48d2-9ad2-944bb15a8a87_jar]"
		notifies :start, "service[service_358ec9ee-c2a0-48d2-9ad2-944bb15a8a87_jar]"
	end
end

if node['CHOReOSData']['serviceData']['358ec9ee-c2a0-48d2-9ad2-944bb15a8a87']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['358ec9ee-c2a0-48d2-9ad2-944bb15a8a87']['InstallationDir']}/service358ec9ee-c2a0-48d2-9ad2-944bb15a8a87Deploy.jar" do
		notifies :stop, "service[service_358ec9ee-c2a0-48d2-9ad2-944bb15a8a87_jar]", :immediately
		#notifies :disable, "service[service_358ec9ee-c2a0-48d2-9ad2-944bb15a8a87_jar]", :immediately
		action :delete
	end
end