#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80']['installationDir']}/service35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80']['InstallationDir']}/service35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80_jar]"
		notifies :start, "service[service_35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80_jar]"
	end
end

if node['CHOReOSData']['serviceData']['35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80']['InstallationDir']}/service35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80Deploy.jar" do
		notifies :stop, "service[service_35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80_jar]", :immediately
		#notifies :disable, "service[service_35e55df0-0cc0-43b9-a20d-0bbf3b7f5e80_jar]", :immediately
		action :delete
	end
end