#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_35f5e5d9-3ca6-43e3-847a-cadab47b8780_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-35f5e5d9-3ca6-43e3-847a-cadab47b8780.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-35f5e5d9-3ca6-43e3-847a-cadab47b8780.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['35f5e5d9-3ca6-43e3-847a-cadab47b8780']['InstallationDir']}/service-35f5e5d9-3ca6-43e3-847a-cadab47b8780.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-35f5e5d9-3ca6-43e3-847a-cadab47b8780.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['35f5e5d9-3ca6-43e3-847a-cadab47b8780']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['35f5e5d9-3ca6-43e3-847a-cadab47b8780']['InstallationDir']}/service-35f5e5d9-3ca6-43e3-847a-cadab47b8780.jar" do
  		source "#{node['CHOReOSData']['serviceData']['35f5e5d9-3ca6-43e3-847a-cadab47b8780']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_35f5e5d9-3ca6-43e3-847a-cadab47b8780_jar]"
		notifies :start, "service[service_35f5e5d9-3ca6-43e3-847a-cadab47b8780_jar]"
	end
end

if node['CHOReOSData']['serviceData']['35f5e5d9-3ca6-43e3-847a-cadab47b8780']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['35f5e5d9-3ca6-43e3-847a-cadab47b8780']['InstallationDir']}/service-35f5e5d9-3ca6-43e3-847a-cadab47b8780.jar" do
		notifies :stop, "service[service_35f5e5d9-3ca6-43e3-847a-cadab47b8780_jar]", :immediately
		#notifies :disable, "service[service_35f5e5d9-3ca6-43e3-847a-cadab47b8780_jar]", :immediately
		action :delete
	end
end