#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_38a02626-f826-44ce-ba46-95eb618750cd_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-38a02626-f826-44ce-ba46-95eb618750cd.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-38a02626-f826-44ce-ba46-95eb618750cd.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['38a02626-f826-44ce-ba46-95eb618750cd']['InstallationDir']}/service-38a02626-f826-44ce-ba46-95eb618750cd.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-38a02626-f826-44ce-ba46-95eb618750cd.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['38a02626-f826-44ce-ba46-95eb618750cd']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['38a02626-f826-44ce-ba46-95eb618750cd']['InstallationDir']}/service-38a02626-f826-44ce-ba46-95eb618750cd.jar" do
  		source "#{node['CHOReOSData']['serviceData']['38a02626-f826-44ce-ba46-95eb618750cd']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_38a02626-f826-44ce-ba46-95eb618750cd_jar]"
		notifies :start, "service[service_38a02626-f826-44ce-ba46-95eb618750cd_jar]"
	end
end

if node['CHOReOSData']['serviceData']['38a02626-f826-44ce-ba46-95eb618750cd']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['38a02626-f826-44ce-ba46-95eb618750cd']['InstallationDir']}/service-38a02626-f826-44ce-ba46-95eb618750cd.jar" do
		notifies :stop, "service[service_38a02626-f826-44ce-ba46-95eb618750cd_jar]", :immediately
		#notifies :disable, "service[service_38a02626-f826-44ce-ba46-95eb618750cd_jar]", :immediately
		action :delete
	end
end