#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_394065eb-f37c-4486-b678-13f66ca9351b_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-394065eb-f37c-4486-b678-13f66ca9351b.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-394065eb-f37c-4486-b678-13f66ca9351b.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['394065eb-f37c-4486-b678-13f66ca9351b']['InstallationDir']}/service-394065eb-f37c-4486-b678-13f66ca9351b.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-394065eb-f37c-4486-b678-13f66ca9351b.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['394065eb-f37c-4486-b678-13f66ca9351b']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['394065eb-f37c-4486-b678-13f66ca9351b']['InstallationDir']}/service-394065eb-f37c-4486-b678-13f66ca9351b.jar" do
  		source "#{node['CHOReOSData']['serviceData']['394065eb-f37c-4486-b678-13f66ca9351b']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_394065eb-f37c-4486-b678-13f66ca9351b_jar]"
		notifies :start, "service[service_394065eb-f37c-4486-b678-13f66ca9351b_jar]"
	end
end

if node['CHOReOSData']['serviceData']['394065eb-f37c-4486-b678-13f66ca9351b']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['394065eb-f37c-4486-b678-13f66ca9351b']['InstallationDir']}/service-394065eb-f37c-4486-b678-13f66ca9351b.jar" do
		notifies :stop, "service[service_394065eb-f37c-4486-b678-13f66ca9351b_jar]", :immediately
		#notifies :disable, "service[service_394065eb-f37c-4486-b678-13f66ca9351b_jar]", :immediately
		action :delete
	end
end