#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_3ccd54a0-fb24-49c4-ad64-d021aa49a855_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service3ccd54a0-fb24-49c4-ad64-d021aa49a855Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['3ccd54a0-fb24-49c4-ad64-d021aa49a855']['installationDir']}/service3ccd54a0-fb24-49c4-ad64-d021aa49a855Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service3ccd54a0-fb24-49c4-ad64-d021aa49a855Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['3ccd54a0-fb24-49c4-ad64-d021aa49a855']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['3ccd54a0-fb24-49c4-ad64-d021aa49a855']['InstallationDir']}/service3ccd54a0-fb24-49c4-ad64-d021aa49a855Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['3ccd54a0-fb24-49c4-ad64-d021aa49a855']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_3ccd54a0-fb24-49c4-ad64-d021aa49a855_jar]"
		notifies :start, "service[service_3ccd54a0-fb24-49c4-ad64-d021aa49a855_jar]"
	end
end

if node['CHOReOSData']['serviceData']['3ccd54a0-fb24-49c4-ad64-d021aa49a855']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['3ccd54a0-fb24-49c4-ad64-d021aa49a855']['InstallationDir']}/service3ccd54a0-fb24-49c4-ad64-d021aa49a855Deploy.jar" do
		notifies :stop, "service[service_3ccd54a0-fb24-49c4-ad64-d021aa49a855_jar]", :immediately
		#notifies :disable, "service[service_3ccd54a0-fb24-49c4-ad64-d021aa49a855_jar]", :immediately
		action :delete
	end
end