#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_3cf9f984-098d-4549-973d-887131bfb9fa_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-3cf9f984-098d-4549-973d-887131bfb9fa.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-3cf9f984-098d-4549-973d-887131bfb9fa.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['3cf9f984-098d-4549-973d-887131bfb9fa']['InstallationDir']}/service-3cf9f984-098d-4549-973d-887131bfb9fa.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-3cf9f984-098d-4549-973d-887131bfb9fa.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['3cf9f984-098d-4549-973d-887131bfb9fa']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['3cf9f984-098d-4549-973d-887131bfb9fa']['InstallationDir']}/service-3cf9f984-098d-4549-973d-887131bfb9fa.jar" do
  		source "#{node['CHOReOSData']['serviceData']['3cf9f984-098d-4549-973d-887131bfb9fa']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_3cf9f984-098d-4549-973d-887131bfb9fa_jar]"
		notifies :start, "service[service_3cf9f984-098d-4549-973d-887131bfb9fa_jar]"
	end
end

if node['CHOReOSData']['serviceData']['3cf9f984-098d-4549-973d-887131bfb9fa']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['3cf9f984-098d-4549-973d-887131bfb9fa']['InstallationDir']}/service-3cf9f984-098d-4549-973d-887131bfb9fa.jar" do
		notifies :stop, "service[service_3cf9f984-098d-4549-973d-887131bfb9fa_jar]", :immediately
		#notifies :disable, "service[service_3cf9f984-098d-4549-973d-887131bfb9fa_jar]", :immediately
		action :delete
	end
end