#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_49002836-78dd-410d-a54f-5fc659f5fa93_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service49002836-78dd-410d-a54f-5fc659f5fa93Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['49002836-78dd-410d-a54f-5fc659f5fa93']['installationDir']}/service49002836-78dd-410d-a54f-5fc659f5fa93Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service49002836-78dd-410d-a54f-5fc659f5fa93Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['49002836-78dd-410d-a54f-5fc659f5fa93']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['49002836-78dd-410d-a54f-5fc659f5fa93']['InstallationDir']}/service49002836-78dd-410d-a54f-5fc659f5fa93Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['49002836-78dd-410d-a54f-5fc659f5fa93']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_49002836-78dd-410d-a54f-5fc659f5fa93_jar]"
		notifies :start, "service[service_49002836-78dd-410d-a54f-5fc659f5fa93_jar]"
	end
end

if node['CHOReOSData']['serviceData']['49002836-78dd-410d-a54f-5fc659f5fa93']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['49002836-78dd-410d-a54f-5fc659f5fa93']['InstallationDir']}/service49002836-78dd-410d-a54f-5fc659f5fa93Deploy.jar" do
		notifies :stop, "service[service_49002836-78dd-410d-a54f-5fc659f5fa93_jar]", :immediately
		#notifies :disable, "service[service_49002836-78dd-410d-a54f-5fc659f5fa93_jar]", :immediately
		action :delete
	end
end