#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_498e4fd3-161f-4d69-b099-699407b3a0ee_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-498e4fd3-161f-4d69-b099-699407b3a0ee.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-498e4fd3-161f-4d69-b099-699407b3a0ee.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['498e4fd3-161f-4d69-b099-699407b3a0ee']['InstallationDir']}/service-498e4fd3-161f-4d69-b099-699407b3a0ee.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-498e4fd3-161f-4d69-b099-699407b3a0ee.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['498e4fd3-161f-4d69-b099-699407b3a0ee']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['498e4fd3-161f-4d69-b099-699407b3a0ee']['InstallationDir']}/service-498e4fd3-161f-4d69-b099-699407b3a0ee.jar" do
  		source "#{node['CHOReOSData']['serviceData']['498e4fd3-161f-4d69-b099-699407b3a0ee']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_498e4fd3-161f-4d69-b099-699407b3a0ee_jar]"
		notifies :start, "service[service_498e4fd3-161f-4d69-b099-699407b3a0ee_jar]"
	end
end

if node['CHOReOSData']['serviceData']['498e4fd3-161f-4d69-b099-699407b3a0ee']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['498e4fd3-161f-4d69-b099-699407b3a0ee']['InstallationDir']}/service-498e4fd3-161f-4d69-b099-699407b3a0ee.jar" do
		notifies :stop, "service[service_498e4fd3-161f-4d69-b099-699407b3a0ee_jar]", :immediately
		#notifies :disable, "service[service_498e4fd3-161f-4d69-b099-699407b3a0ee_jar]", :immediately
		action :delete
	end
end