#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e']['InstallationDir']}/service-5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e']['InstallationDir']}/service-5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e.jar" do
  		source "#{node['CHOReOSData']['serviceData']['5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e_jar]"
		notifies :start, "service[service_5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e_jar]"
	end
end

if node['CHOReOSData']['serviceData']['5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e']['InstallationDir']}/service-5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e.jar" do
		notifies :stop, "service[service_5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e_jar]", :immediately
		#notifies :disable, "service[service_5e2e2aca-07e5-4b0e-b87e-0cdbbf004d4e_jar]", :immediately
		action :delete
	end
end