#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_5f010be0-2174-464d-bbea-e211a0324166_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service5f010be0-2174-464d-bbea-e211a0324166Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['5f010be0-2174-464d-bbea-e211a0324166']['installationDir']}/service5f010be0-2174-464d-bbea-e211a0324166Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service5f010be0-2174-464d-bbea-e211a0324166Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['5f010be0-2174-464d-bbea-e211a0324166']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['5f010be0-2174-464d-bbea-e211a0324166']['InstallationDir']}/service5f010be0-2174-464d-bbea-e211a0324166Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['5f010be0-2174-464d-bbea-e211a0324166']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_5f010be0-2174-464d-bbea-e211a0324166_jar]"
		notifies :start, "service[service_5f010be0-2174-464d-bbea-e211a0324166_jar]"
	end
end

if node['CHOReOSData']['serviceData']['5f010be0-2174-464d-bbea-e211a0324166']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['5f010be0-2174-464d-bbea-e211a0324166']['InstallationDir']}/service5f010be0-2174-464d-bbea-e211a0324166Deploy.jar" do
		notifies :stop, "service[service_5f010be0-2174-464d-bbea-e211a0324166_jar]", :immediately
		#notifies :disable, "service[service_5f010be0-2174-464d-bbea-e211a0324166_jar]", :immediately
		action :delete
	end
end