#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_6b93b432-6dbf-48dc-b76b-4752453a2ac6_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service6b93b432-6dbf-48dc-b76b-4752453a2ac6Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['6b93b432-6dbf-48dc-b76b-4752453a2ac6']['installationDir']}/service6b93b432-6dbf-48dc-b76b-4752453a2ac6Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service6b93b432-6dbf-48dc-b76b-4752453a2ac6Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['6b93b432-6dbf-48dc-b76b-4752453a2ac6']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['6b93b432-6dbf-48dc-b76b-4752453a2ac6']['InstallationDir']}/service6b93b432-6dbf-48dc-b76b-4752453a2ac6Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['6b93b432-6dbf-48dc-b76b-4752453a2ac6']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_6b93b432-6dbf-48dc-b76b-4752453a2ac6_jar]"
		notifies :start, "service[service_6b93b432-6dbf-48dc-b76b-4752453a2ac6_jar]"
	end
end

if node['CHOReOSData']['serviceData']['6b93b432-6dbf-48dc-b76b-4752453a2ac6']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['6b93b432-6dbf-48dc-b76b-4752453a2ac6']['InstallationDir']}/service6b93b432-6dbf-48dc-b76b-4752453a2ac6Deploy.jar" do
		notifies :stop, "service[service_6b93b432-6dbf-48dc-b76b-4752453a2ac6_jar]", :immediately
		#notifies :disable, "service[service_6b93b432-6dbf-48dc-b76b-4752453a2ac6_jar]", :immediately
		action :delete
	end
end