#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_6c95ee70-69d5-4372-8a1f-7ff535b96d83_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-6c95ee70-69d5-4372-8a1f-7ff535b96d83.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-6c95ee70-69d5-4372-8a1f-7ff535b96d83.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['6c95ee70-69d5-4372-8a1f-7ff535b96d83']['InstallationDir']}/service-6c95ee70-69d5-4372-8a1f-7ff535b96d83.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-6c95ee70-69d5-4372-8a1f-7ff535b96d83.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['6c95ee70-69d5-4372-8a1f-7ff535b96d83']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['6c95ee70-69d5-4372-8a1f-7ff535b96d83']['InstallationDir']}/service-6c95ee70-69d5-4372-8a1f-7ff535b96d83.jar" do
  		source "#{node['CHOReOSData']['serviceData']['6c95ee70-69d5-4372-8a1f-7ff535b96d83']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_6c95ee70-69d5-4372-8a1f-7ff535b96d83_jar]"
		notifies :start, "service[service_6c95ee70-69d5-4372-8a1f-7ff535b96d83_jar]"
	end
end

if node['CHOReOSData']['serviceData']['6c95ee70-69d5-4372-8a1f-7ff535b96d83']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['6c95ee70-69d5-4372-8a1f-7ff535b96d83']['InstallationDir']}/service-6c95ee70-69d5-4372-8a1f-7ff535b96d83.jar" do
		notifies :stop, "service[service_6c95ee70-69d5-4372-8a1f-7ff535b96d83_jar]", :immediately
		#notifies :disable, "service[service_6c95ee70-69d5-4372-8a1f-7ff535b96d83_jar]", :immediately
		action :delete
	end
end