#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_6cad3980-c9ef-48b3-8147-b717bffdc129_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service6cad3980-c9ef-48b3-8147-b717bffdc129Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['6cad3980-c9ef-48b3-8147-b717bffdc129']['installationDir']}/service6cad3980-c9ef-48b3-8147-b717bffdc129Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service6cad3980-c9ef-48b3-8147-b717bffdc129Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['6cad3980-c9ef-48b3-8147-b717bffdc129']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['6cad3980-c9ef-48b3-8147-b717bffdc129']['InstallationDir']}/service6cad3980-c9ef-48b3-8147-b717bffdc129Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['6cad3980-c9ef-48b3-8147-b717bffdc129']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_6cad3980-c9ef-48b3-8147-b717bffdc129_jar]"
		notifies :start, "service[service_6cad3980-c9ef-48b3-8147-b717bffdc129_jar]"
	end
end

if node['CHOReOSData']['serviceData']['6cad3980-c9ef-48b3-8147-b717bffdc129']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['6cad3980-c9ef-48b3-8147-b717bffdc129']['InstallationDir']}/service6cad3980-c9ef-48b3-8147-b717bffdc129Deploy.jar" do
		notifies :stop, "service[service_6cad3980-c9ef-48b3-8147-b717bffdc129_jar]", :immediately
		#notifies :disable, "service[service_6cad3980-c9ef-48b3-8147-b717bffdc129_jar]", :immediately
		action :delete
	end
end