#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_6e10bb7b-1b1e-43b6-bafd-502826b83b89_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service6e10bb7b-1b1e-43b6-bafd-502826b83b89Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['6e10bb7b-1b1e-43b6-bafd-502826b83b89']['installationDir']}/service6e10bb7b-1b1e-43b6-bafd-502826b83b89Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service6e10bb7b-1b1e-43b6-bafd-502826b83b89Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['6e10bb7b-1b1e-43b6-bafd-502826b83b89']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['6e10bb7b-1b1e-43b6-bafd-502826b83b89']['InstallationDir']}/service6e10bb7b-1b1e-43b6-bafd-502826b83b89Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['6e10bb7b-1b1e-43b6-bafd-502826b83b89']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_6e10bb7b-1b1e-43b6-bafd-502826b83b89_jar]"
		notifies :start, "service[service_6e10bb7b-1b1e-43b6-bafd-502826b83b89_jar]"
	end
end

if node['CHOReOSData']['serviceData']['6e10bb7b-1b1e-43b6-bafd-502826b83b89']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['6e10bb7b-1b1e-43b6-bafd-502826b83b89']['InstallationDir']}/service6e10bb7b-1b1e-43b6-bafd-502826b83b89Deploy.jar" do
		notifies :stop, "service[service_6e10bb7b-1b1e-43b6-bafd-502826b83b89_jar]", :immediately
		#notifies :disable, "service[service_6e10bb7b-1b1e-43b6-bafd-502826b83b89_jar]", :immediately
		action :delete
	end
end