#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_6eb76b08-ae5f-4f15-8352-4492c053eaec_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-6eb76b08-ae5f-4f15-8352-4492c053eaec.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-6eb76b08-ae5f-4f15-8352-4492c053eaec.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['6eb76b08-ae5f-4f15-8352-4492c053eaec']['InstallationDir']}/service-6eb76b08-ae5f-4f15-8352-4492c053eaec.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-6eb76b08-ae5f-4f15-8352-4492c053eaec.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['6eb76b08-ae5f-4f15-8352-4492c053eaec']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['6eb76b08-ae5f-4f15-8352-4492c053eaec']['InstallationDir']}/service-6eb76b08-ae5f-4f15-8352-4492c053eaec.jar" do
  		source "#{node['CHOReOSData']['serviceData']['6eb76b08-ae5f-4f15-8352-4492c053eaec']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_6eb76b08-ae5f-4f15-8352-4492c053eaec_jar]"
		notifies :start, "service[service_6eb76b08-ae5f-4f15-8352-4492c053eaec_jar]"
	end
end

if node['CHOReOSData']['serviceData']['6eb76b08-ae5f-4f15-8352-4492c053eaec']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['6eb76b08-ae5f-4f15-8352-4492c053eaec']['InstallationDir']}/service-6eb76b08-ae5f-4f15-8352-4492c053eaec.jar" do
		notifies :stop, "service[service_6eb76b08-ae5f-4f15-8352-4492c053eaec_jar]", :immediately
		#notifies :disable, "service[service_6eb76b08-ae5f-4f15-8352-4492c053eaec_jar]", :immediately
		action :delete
	end
end