#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_6eed750d-0460-4982-b8ae-6b60f6ca5511_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service6eed750d-0460-4982-b8ae-6b60f6ca5511Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['6eed750d-0460-4982-b8ae-6b60f6ca5511']['installationDir']}/service6eed750d-0460-4982-b8ae-6b60f6ca5511Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service6eed750d-0460-4982-b8ae-6b60f6ca5511Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['6eed750d-0460-4982-b8ae-6b60f6ca5511']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['6eed750d-0460-4982-b8ae-6b60f6ca5511']['InstallationDir']}/service6eed750d-0460-4982-b8ae-6b60f6ca5511Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['6eed750d-0460-4982-b8ae-6b60f6ca5511']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_6eed750d-0460-4982-b8ae-6b60f6ca5511_jar]"
		notifies :start, "service[service_6eed750d-0460-4982-b8ae-6b60f6ca5511_jar]"
	end
end

if node['CHOReOSData']['serviceData']['6eed750d-0460-4982-b8ae-6b60f6ca5511']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['6eed750d-0460-4982-b8ae-6b60f6ca5511']['InstallationDir']}/service6eed750d-0460-4982-b8ae-6b60f6ca5511Deploy.jar" do
		notifies :stop, "service[service_6eed750d-0460-4982-b8ae-6b60f6ca5511_jar]", :immediately
		#notifies :disable, "service[service_6eed750d-0460-4982-b8ae-6b60f6ca5511_jar]", :immediately
		action :delete
	end
end